/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.vampire;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.projectile.LaserProjectile;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.spec.VampireSpec;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class SpaceRipperAttack
extends AbstractMove<SpaceRipperAttack, VampireSpec> {
    public SpaceRipperAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<SpaceRipperAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(VampireSpec attacker, LivingEntity user) {
        Vec3 rotVec = user.m_20154_();
        int chargeTime = this.getChargeTime();
        for (int i = -1; i < 3; i += 2) {
            LaserProjectile laser = new LaserProjectile(attacker.getEntityWorld(), user);
            laser.m_20256_(attacker.getBaseEntity().m_20154_().m_82490_(2.0 + (double)(chargeTime - 15) / 10.0));
            Vec3 sideOffset = rotVec.m_82524_(1.5707964f * (float)i).m_82490_(0.125);
            Vec3 offset = RotationUtil.vecPlayerToWorld(sideOffset.f_82479_, sideOffset.f_82480_ + (double)user.m_20192_(), sideOffset.f_82481_, GravityChangerAPI.getGravityDirection((Entity)user));
            Vec3 offsetHeightPos = attacker.getBaseEntity().m_20182_().m_82549_(offset);
            laser.m_146884_(offsetHeightPos);
            if (chargeTime > 24) {
                laser.setUnblockable(true);
            }
            attacker.getEntityWorld().m_7967_((Entity)laser);
            JComponentPlatformUtils.getShockwaveHandler(user.m_9236_()).addShockwave(offsetHeightPos, rotVec, 2.0f);
        }
        JUtils.serverPlaySound((SoundEvent)JSoundRegistry.VAMPIRE_LASER_FIRE.get(), (ServerLevel)user.m_9236_(), user.m_20182_(), 96.0);
        return Set.of();
    }

    @Override
    @NonNull
    protected SpaceRipperAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SpaceRipperAttack copy() {
        return this.copyExtras(new SpaceRipperAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<SpaceRipperAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SpaceRipperAttack>, SpaceRipperAttack> buildCodec(RecordCodecBuilder.Instance<SpaceRipperAttack> instance) {
            return this.baseDefault(instance, SpaceRipperAttack::new);
        }
    }
}

