/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.whitesnake;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.projectile.WSAcidProjectile;
import net.arna.jcraft.common.entity.stand.WhiteSnakeEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec2;

public final class ChargedSpewAttack
extends AbstractSimpleAttack<ChargedSpewAttack, WhiteSnakeEntity> {
    public ChargedSpewAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<ChargedSpewAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(WhiteSnakeEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        Direction gravity = GravityChangerAPI.getGravityDirection((Entity)user);
        for (int i = 0; i < 5; ++i) {
            WSAcidProjectile acidProjectile = new WSAcidProjectile(attacker.m_9236_(), user);
            Vec2 corrected = RotationUtil.rotPlayerToWorld(user.m_146908_() - 75.0f + (float)i * 37.5f, user.m_146909_(), gravity);
            JUtils.shoot((Projectile)acidProjectile, (Entity)user, corrected.f_82471_, corrected.f_82470_, 0.0f, 0.66f, 0.0f);
            acidProjectile.m_146884_(attacker.m_146892_());
            attacker.m_9236_().m_7967_((Entity)acidProjectile);
        }
        return targets;
    }

    @Override
    @NonNull
    protected ChargedSpewAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public ChargedSpewAttack copy() {
        return this.copyExtras(new ChargedSpewAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<ChargedSpewAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<ChargedSpewAttack>, ChargedSpewAttack> buildCodec(RecordCodecBuilder.Instance<ChargedSpewAttack> instance) {
            return this.attackDefault(instance, ChargedSpewAttack::new);
        }
    }
}

