/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.whitesnake;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.entity.stand.WhiteSnakeEntity;
import net.arna.jcraft.common.item.StandDiscItem;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class GiveStandAttack
extends AbstractSimpleAttack<GiveStandAttack, WhiteSnakeEntity> {
    public GiveStandAttack(int cooldown, int windup, int duration, float moveDistance, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, 0.0f, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<GiveStandAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean conditionsMet(WhiteSnakeEntity attacker) {
        if (!attacker.hasUser()) {
            return false;
        }
        return super.conditionsMet(attacker) && attacker.getUserOrThrow().m_21206_().m_41720_() == JItemRegistry.STAND_DISC.get();
    }

    @Override
    public void onInitiate(WhiteSnakeEntity attacker) {
        attacker.m_8061_(EquipmentSlot.OFFHAND, attacker.getUserOrThrow().m_21206_());
        attacker.getUserOrThrow().m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        super.onInitiate(attacker);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(WhiteSnakeEntity attacker, LivingEntity user) {
        ItemStack itemStack = attacker.m_21206_();
        super.perform(attacker, user).stream().findFirst().ifPresent(target -> {
            if (target.m_6095_().m_204039_(JTagRegistry.CAN_NEVER_HAVE_STAND) || !itemStack.m_150930_((Item)JItemRegistry.STAND_DISC.get())) {
                return;
            }
            int itemSkin = 0;
            CompoundTag data = itemStack.m_41784_();
            CommonStandComponent standData = JComponentPlatformUtils.getStandComponent(target);
            if (standData.getType() != null) {
                return;
            }
            StandType itemStand = StandDiscItem.getStandType(itemStack);
            if (itemStand == null) {
                return;
            }
            if (data.m_128425_("Skin", 3)) {
                itemSkin = data.m_128451_("Skin");
            }
            standData.setTypeAndSkin(itemStand, itemSkin);
            data.m_128473_("StandID");
            data.m_128473_("Skin");
            StandEntity<?, ?> stand = standData.getStand();
            if (stand != null) {
                stand.m_146870_();
            }
            JCraft.summon(target.m_9236_(), target);
        });
        attacker.getUserOrThrow().m_8061_(EquipmentSlot.OFFHAND, itemStack);
        attacker.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        return Set.of();
    }

    @Override
    @NonNull
    protected GiveStandAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public GiveStandAttack copy() {
        return this.copyExtras(new GiveStandAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<GiveStandAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<GiveStandAttack>, GiveStandAttack> buildCodec(RecordCodecBuilder.Instance<GiveStandAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.stun(), this.hitboxSize(), this.knockback(), this.offset()).apply(instance, this.applyAttackExtras(GiveStandAttack::new));
        }
    }
}

