/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.whitesnake;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.projectile.WSAcidProjectile;
import net.arna.jcraft.common.entity.stand.WhiteSnakeEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public final class PoisonSpewAttack
extends AbstractSimpleAttack<PoisonSpewAttack, WhiteSnakeEntity> {
    public PoisonSpewAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<PoisonSpewAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(WhiteSnakeEntity attacker, LivingEntity user) {
        WSAcidProjectile acidProjectile = new WSAcidProjectile(attacker.m_9236_(), user);
        acidProjectile.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.33f, 0.0f);
        acidProjectile.m_146884_(attacker.m_146892_());
        attacker.m_9236_().m_7967_((Entity)acidProjectile);
        return super.perform(attacker, user);
    }

    @Override
    @NonNull
    protected PoisonSpewAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public PoisonSpewAttack copy() {
        return this.copyExtras(new PoisonSpewAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<PoisonSpewAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<PoisonSpewAttack>, PoisonSpewAttack> buildCodec(RecordCodecBuilder.Instance<PoisonSpewAttack> instance) {
            return this.attackDefault(instance, PoisonSpewAttack::new);
        }
    }
}

