/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.block;

import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import net.arna.jcraft.api.registry.JBlockEntityTypeRegistry;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class CoffinBlock
extends BedBlock {
    private static final VoxelShape NORTH_SHAPE;
    private static final VoxelShape SOUTH_SHAPE;
    private static final VoxelShape WEST_SHAPE;
    private static final VoxelShape EAST_SHAPE;
    private static List<ItemStack> DROP_LIST;

    public CoffinBlock(BlockBehaviour.Properties settings) {
        super(DyeColor.RED, settings);
    }

    public static void init() {
        DROP_LIST = List.of(new ItemStack((ItemLike)JItemRegistry.COFFIN_BLOCK.get()));
    }

    @NonNull
    public InteractionResult m_6227_(@NonNull BlockState state, Level world, @NonNull BlockPos pos, @NonNull Player player, @NonNull InteractionHand hand, @NonNull BlockHitResult hit) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        if (hit == null) {
            throw new NullPointerException("hit is marked non-null but is null");
        }
        if (world.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_((Property)f_49440_) != BedPart.HEAD && !(state = world.m_8055_(pos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        if (!CoffinBlock.m_49488_((Level)world)) {
            world.m_7471_(pos, false);
            BlockPos blockPos = pos.m_121945_(facing.m_122424_());
            if (world.m_8055_(blockPos).m_60713_((Block)this)) {
                world.m_7471_(blockPos, false);
            }
            Vec3 vec3d = pos.m_252807_();
            world.m_254877_(null, world.m_269111_().m_269488_(vec3d), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Level.ExplosionInteraction.BLOCK);
        } else if (((Boolean)state.m_61143_((Property)f_49441_)).booleanValue()) {
            if (!this.m_49490_(world, pos)) {
                player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            }
        } else {
            Either sleep = player.m_7720_(pos);
            sleep.ifRight(unit -> {
                Vec3 bedPos = player.m_20182_().m_82520_(0.0, -0.2, 0.0);
                player.m_6021_(bedPos.f_82479_, bedPos.f_82480_, bedPos.f_82481_);
            });
            sleep.ifLeft(problem -> {
                if (problem.m_36423_() != null) {
                    player.m_5661_(problem.m_36423_(), true);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(@NonNull BlockPlaceContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        BlockState state = super.m_5573_(context);
        if (state != null) {
            state.m_61124_((Property)f_49441_, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    @Nullable
    public BlockEntity m_142194_(@NonNull BlockPos pos, @NonNull BlockState state) {
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        return ((BlockEntityType)JBlockEntityTypeRegistry.COFFIN_TILE.get()).m_155264_(pos, state);
    }

    @NonNull
    public List<ItemStack> m_49635_(@NonNull BlockState state, @NonNull LootParams.Builder params) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return state.m_61143_((Property)f_49440_) == BedPart.FOOT ? DROP_LIST : Collections.emptyList();
    }

    @NonNull
    public VoxelShape m_5940_(@NonNull BlockState state, @NonNull BlockGetter world, @NonNull BlockPos pos, @NonNull CollisionContext context) {
        VoxelShape voxelShape;
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (BedPart.FOOT == state.m_61143_((Property)BedBlock.f_49440_)) {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case NORTH: {
                    voxelShape = NORTH_SHAPE;
                    break;
                }
                case SOUTH: {
                    voxelShape = SOUTH_SHAPE;
                    break;
                }
                case WEST: {
                    voxelShape = WEST_SHAPE;
                    break;
                }
                case EAST: {
                    voxelShape = EAST_SHAPE;
                    break;
                }
                default: {
                    voxelShape = Shapes.m_83144_();
                    break;
                }
            }
        } else {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case NORTH: {
                    voxelShape = SOUTH_SHAPE;
                    break;
                }
                case SOUTH: {
                    voxelShape = NORTH_SHAPE;
                    break;
                }
                case WEST: {
                    voxelShape = EAST_SHAPE;
                    break;
                }
                case EAST: {
                    voxelShape = WEST_SHAPE;
                    break;
                }
                default: {
                    voxelShape = Shapes.m_83144_();
                }
            }
        }
        return voxelShape;
    }

    static {
        SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-1.0, (double)0.0, (double)0.0, (double)17.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-1.0, (double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)6.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)2.0, (double)5.0, (double)16.0), Block.m_49796_((double)16.0, (double)0.0, (double)0.0, (double)17.0, (double)5.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)6.0, (double)1.0), Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)5.0, (double)2.0)});
        EAST_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)-1.0, (double)16.0, (double)1.0, (double)17.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)-1.0, (double)16.0, (double)5.0, (double)0.0), Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)1.0), Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)5.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0, (double)17.0), Block.m_49796_((double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)5.0, (double)15.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)6.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)2.0, (double)5.0, (double)15.0)});
        NORTH_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-1.0, (double)0.0, (double)0.0, (double)17.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-1.0, (double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)6.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)5.0, (double)14.0), Block.m_49796_((double)16.0, (double)0.0, (double)0.0, (double)17.0, (double)5.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)15.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)5.0, (double)14.0), Block.m_49796_((double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)5.0, (double)15.0)});
        WEST_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)-1.0, (double)16.0, (double)1.0, (double)17.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)-1.0, (double)16.0, (double)5.0, (double)0.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)6.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)5.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0, (double)17.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)5.0, (double)15.0), Block.m_49796_((double)14.0, (double)1.0, (double)0.0, (double)15.0, (double)6.0, (double)16.0), Block.m_49796_((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)5.0, (double)15.0)});
    }
}

