/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.SpecData;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.common.command.AboutStandCommand;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class AboutSpecCommand {
    private static final Component newLine = Component.m_237113_((String)"\n");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"spec").then(Commands.m_82127_((String)"about").executes(AboutSpecCommand::run)));
    }

    public static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        JSpec<?, ?> spec = JUtils.getSpec((LivingEntity)player);
        if (spec == null) {
            player.m_5661_((Component)Component.m_237115_((String)"jcraft.commands.error.nospec"), false);
            return 0;
        }
        SpecType specType = spec.getType();
        SpecData data = spec.getSpecData();
        MutableComponent text = Component.m_237119_();
        text.m_7220_((Component)Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"Name: ")).m_7220_((Component)data.getName().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_7220_(newLine));
        text.m_7220_((Component)data.getDescription().m_6881_().m_130940_(ChatFormatting.GREEN));
        text.m_7220_((Component)Component.m_237119_().m_7220_(newLine).m_7220_(newLine));
        MutableComponent moves = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"MOVES:").m_130940_(ChatFormatting.DARK_GREEN)).m_7220_((Component)Component.m_237113_((String)"\n"));
        MoveMap<?, ?> moveMap = spec.getMoveMap();
        for (MoveClass type : MoveClass.values()) {
            for (MoveMap.Entry<?, ?> entry : moveMap.getEntries(type)) {
                AboutStandCommand.appendMove(entry, moves, Component.m_237113_((String)"\u25cf ").m_130940_(ChatFormatting.GREEN), false);
                if (entry.getCrouchingVariant() != null) {
                    AboutStandCommand.appendMove(entry.getCrouchingVariant(), moves, Component.m_237113_((String)"  \u25cf CROUCHING ").m_130940_(ChatFormatting.DARK_AQUA), true);
                }
                if (entry.getAerialVariant() == null) continue;
                AboutStandCommand.appendMove(entry.getAerialVariant(), moves, Component.m_237113_((String)"  \u25cf AERIAL ").m_130940_(ChatFormatting.GOLD), true);
            }
        }
        text.m_7220_((Component)moves);
        text.m_7220_((Component)Component.m_237113_((String)"\n"));
        text.m_7220_(data.getDetails());
        player.m_213846_((Component)text);
        return 1;
    }
}

