/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class GravityCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalSet = Commands.m_82127_((String)"add");
        for (Direction direction : Direction.values()) {
            literalSet.then(Commands.m_82127_((String)direction.m_122433_()).then(Commands.m_82129_((String)"priority", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"duration", (ArgumentType)IntegerArgumentType.integer()).executes(context -> GravityCommand.executeSet((CommandSourceStack)context.getSource(), direction, IntegerArgumentType.getInteger((CommandContext)context, (String)"priority"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), Collections.singleton(((CommandSourceStack)context.getSource()).m_230896_())))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> GravityCommand.executeSet((CommandSourceStack)context.getSource(), direction, IntegerArgumentType.getInteger((CommandContext)context, (String)"priority"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), EntityArgument.m_91461_((CommandContext)context, (String)"entities")))))));
        }
        LiteralArgumentBuilder literalSetDefault = Commands.m_82127_((String)"set");
        for (Direction direction : Direction.values()) {
            literalSetDefault.then(((LiteralArgumentBuilder)Commands.m_82127_((String)direction.m_122433_()).executes(context -> GravityCommand.executeSetDefault((CommandSourceStack)context.getSource(), direction, Collections.singleton(((CommandSourceStack)context.getSource()).m_230896_())))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> GravityCommand.executeSetDefault((CommandSourceStack)context.getSource(), direction, EntityArgument.m_91461_((CommandContext)context, (String)"entities")))));
        }
        LiteralArgumentBuilder literalRotate = Commands.m_82127_((String)"rotate");
        for (FacingDirection facingDirection : FacingDirection.values()) {
            literalRotate.then(((LiteralArgumentBuilder)Commands.m_82127_((String)facingDirection.getName()).executes(context -> GravityCommand.executeRotate((CommandSourceStack)context.getSource(), facingDirection, Collections.singleton(((CommandSourceStack)context.getSource()).m_230896_())))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> GravityCommand.executeRotate((CommandSourceStack)context.getSource(), facingDirection, EntityArgument.m_91461_((CommandContext)context, (String)"entities")))));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"jgravity").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(context -> GravityCommand.executeGet((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_()))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91449_()).executes(context -> GravityCommand.executeGet((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"entities")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cleargravity").executes(context -> GravityCommand.executeClearGravity((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_230896_())))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91449_()).executes(context -> GravityCommand.executeClearGravity((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"entities")))))).then((ArgumentBuilder)literalSet)).then((ArgumentBuilder)literalSetDefault)).then((ArgumentBuilder)literalRotate)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"randomise").executes(context -> GravityCommand.executeRandomise((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).m_230896_())))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> GravityCommand.executeRandomise((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"entities"))))));
    }

    private static void getSendFeedback(CommandSourceStack source, Entity entity, Direction gravityDirection) {
        MutableComponent text = Component.m_237115_((String)("direction." + gravityDirection.m_122433_()));
        if (source.m_81373_() != null && source.m_81373_() == entity) {
            source.m_288197_(() -> GravityCommand.lambda$getSendFeedback$13((Component)text), true);
        } else {
            source.m_288197_(() -> GravityCommand.lambda$getSendFeedback$14(entity, (Component)text), true);
        }
    }

    private static int executeGet(CommandSourceStack source, Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        GravityCommand.getSendFeedback(source, entity, gravityDirection);
        return gravityDirection.m_122411_();
    }

    private static int executeSet(CommandSourceStack source, Direction gravityDirection, int priority, int duration, Collection<? extends Entity> entities) {
        int i = 0;
        for (Entity entity : entities) {
            GravityChangerAPI.addGravity(entity, new Gravity(gravityDirection, priority, duration, "command"));
            ++i;
        }
        return i;
    }

    private static int executeSetDefault(CommandSourceStack source, Direction gravityDirection, Collection<? extends Entity> entities) {
        int i = 0;
        for (Entity entity : entities) {
            if (GravityChangerAPI.getDefaultGravityDirection(entity) == gravityDirection) continue;
            GravityChangerAPI.setDefaultGravityDirection(entity, gravityDirection, new RotationParameters());
            GravityCommand.getSendFeedback(source, entity, gravityDirection);
            ++i;
        }
        return i;
    }

    private static int executeRotate(CommandSourceStack source, FacingDirection relativeDirection, Collection<? extends Entity> entities) {
        int i = 0;
        for (Entity entity : entities) {
            Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
            Direction combinedRelativeDirection = switch (relativeDirection.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> Direction.DOWN;
                case 1 -> Direction.UP;
                case 2, 3, 4, 5 -> Direction.m_122407_((int)(relativeDirection.getHorizontalOffset() + Direction.m_122364_((double)entity.m_146908_()).m_122416_()));
            };
            Direction newGravityDirection = RotationUtil.dirPlayerToWorld(combinedRelativeDirection, gravityDirection);
            GravityChangerAPI.setDefaultGravityDirection(entity, newGravityDirection, new RotationParameters());
            GravityCommand.getSendFeedback(source, entity, newGravityDirection);
            ++i;
        }
        return i;
    }

    private static int executeRandomise(CommandSourceStack source, Collection<? extends Entity> entities) {
        int i = 0;
        for (Entity entity : entities) {
            Direction gravityDirection = Direction.m_235672_((RandomSource)source.m_81372_().f_46441_);
            if (GravityChangerAPI.getGravityDirection(entity) == gravityDirection) continue;
            GravityChangerAPI.setDefaultGravityDirection(entity, gravityDirection, new RotationParameters());
            GravityCommand.getSendFeedback(source, entity, gravityDirection);
            ++i;
        }
        return i;
    }

    private static int executeClearGravity(CommandSourceStack source, Collection<? extends Entity> entities) {
        int i = 0;
        for (Entity entity : entities) {
            GravityChangerAPI.clearGravity(entity, new RotationParameters());
            ++i;
        }
        return i;
    }

    private static /* synthetic */ Component lambda$getSendFeedback$14(Entity entity, Component text) {
        return Component.m_237110_((String)"commands.gravity.get.other", (Object[])new Object[]{entity.m_5446_(), text});
    }

    private static /* synthetic */ Component lambda$getSendFeedback$13(Component text) {
        return Component.m_237110_((String)"commands.gravity.get.self", (Object[])new Object[]{text});
    }

    public static enum FacingDirection {
        DOWN(-1, "down"),
        UP(-1, "up"),
        FORWARD(0, "forward"),
        BACKWARD(2, "backward"),
        LEFT(3, "left"),
        RIGHT(1, "right");

        private final int horizontalOffset;
        private final String name;

        private FacingDirection(int horizontalOffset, String name) {
            this.horizontalOffset = horizontalOffset;
            this.name = name;
        }

        public int getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public String getName() {
            return this.name;
        }
    }
}

