/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.command;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.arna.jcraft.api.IAttackerType;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.argumenttype.SpecArgumentType;
import net.arna.jcraft.common.argumenttype.StandArgumentType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class JCraftChangesCommand {
    private static Map<ResourceLocation, List<Pair<String, List<Pair<Component, MapDifference<String, Object>>>>>> CHANGES;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"jcraft").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"changes").executes(ctx -> JCraftChangesCommand.run((CommandContext<CommandSourceStack>)ctx, null))).then(Commands.m_82129_((String)"stand", (ArgumentType)StandArgumentType.stand()).executes(ctx -> JCraftChangesCommand.run((CommandContext<CommandSourceStack>)ctx, (IAttackerType)ctx.getArgument("stand", StandType.class))))).then(Commands.m_82129_((String)"spec", (ArgumentType)SpecArgumentType.spec()).executes(ctx -> JCraftChangesCommand.run((CommandContext<CommandSourceStack>)ctx, (IAttackerType)ctx.getArgument("spec", SpecType.class))))));
    }

    private static int run(CommandContext<CommandSourceStack> ctx, IAttackerType type) {
        if (CHANGES == null) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"jcraft.commands.changes.looking"), true);
        }
        (CHANGES == null ? CompletableFuture.supplyAsync(JCraftChangesCommand::findChanges) : CompletableFuture.completedFuture(CHANGES)).thenAccept(changes -> {
            CHANGES = changes;
            if (type != null) {
                JCraftChangesCommand.sendChanges(ctx, type.getId(), (List)changes.get(type.getId()));
                return;
            }
            changes.forEach((type1, typeChanges) -> {
                if (JCraftChangesCommand.noChanges(typeChanges)) {
                    return;
                }
                JCraftChangesCommand.sendChanges(ctx, type1, typeChanges);
            });
        });
        return 1;
    }

    private static void sendChanges(CommandContext<CommandSourceStack> ctx, ResourceLocation type, List<Pair<String, List<Pair<Component, MapDifference<String, Object>>>>> changes) {
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"jcraft.commands.changes.type", (Object[])new Object[]{type}), true);
        if (JCraftChangesCommand.noChanges(changes)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237119_().m_130946_("    ").m_7220_((Component)Component.m_237115_((String)"jcraft.commands.changes.no_changes").m_130940_(ChatFormatting.ITALIC)), true);
            return;
        }
        for (Pair<String, List<Pair<Component, MapDifference<String, Object>>>> moveSet : changes) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237119_().m_130946_("    ").m_7220_((Component)Component.m_237110_((String)"jcraft.commands.changes.move_set", (Object[])new Object[]{moveSet.getFirst()})), true);
            for (Pair moveChanges : (List)moveSet.getSecond()) {
                MapDifference diff = (MapDifference)moveChanges.getSecond();
                Map propsChanged = diff.entriesDiffering();
                Map propsAdded = diff.entriesOnlyOnRight();
                Map propsRemoved = diff.entriesOnlyOnLeft();
                propsChanged.forEach((prop, change) -> {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237119_().m_130946_("        ").m_7220_((Component)Component.m_237110_((String)"jcraft.commands.changes.property", (Object[])new Object[]{moveChanges.getFirst(), prop})), true);
                    if (String.valueOf(change.leftValue()).length() > 50 || String.valueOf(change.rightValue()).length() > 50) {
                        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237119_().m_130946_("            ").m_7220_((Component)Component.m_237115_((String)"jcraft.commands.changes.too_long").m_130940_(ChatFormatting.ITALIC)), true);
                    } else {
                        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237119_().m_130946_("            ").m_7220_((Component)Component.m_237110_((String)"jcraft.commands.changes.change", (Object[])new Object[]{change.leftValue(), change.rightValue()})), true);
                    }
                });
                propsAdded.forEach((prop, value) -> {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237119_().m_130946_("        ").m_7220_((Component)Component.m_237110_((String)"jcraft.commands.changes.property", (Object[])new Object[]{moveChanges.getFirst(), prop})), true);
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237119_().m_130946_("            ").m_7220_((Component)Component.m_237110_((String)"jcraft.commands.changes.addition", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(value)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN)), true);
                });
                propsRemoved.forEach((prop, value) -> {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237119_().m_130946_("        ").m_7220_((Component)Component.m_237110_((String)"jcraft.commands.changes.property", (Object[])new Object[]{moveChanges.getFirst(), prop})), true);
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237119_().m_130946_("            ").m_7220_((Component)Component.m_237110_((String)"jcraft.commands.changes.removal", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(value)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED)), true);
                });
            }
        }
    }

    private static boolean noChanges(List<Pair<String, List<Pair<Component, MapDifference<String, Object>>>>> changes) {
        return changes.stream().allMatch(p -> ((List)p.getSecond()).stream().allMatch(p1 -> ((MapDifference)p1.getSecond()).areEqual()));
    }

    @NotNull
    private static @NotNull Map<ResourceLocation, @NotNull List<Pair<String, List<Pair<Component, MapDifference<String, Object>>>>>> findChanges() {
        return MoveSetManager.getMoveSets().entrySet().stream().map(moveSets -> Pair.of((Object)((ResourceLocation)moveSets.getKey()), ((Map)moveSets.getValue()).values().stream().map(moveSet -> Pair.of((Object)moveSet.getName(), JCraftChangesCommand.findChanges(moveSet))).filter(p -> p.getSecond() != null).toList())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private static List<Pair<Component, MapDifference<String, Object>>> findChanges(MoveSet<?, ?> moveSet) {
        DataResult original = moveSet.write(JsonOps.INSTANCE);
        DataResult modified = moveSet.writeModified(JsonOps.INSTANCE);
        if (original.result().isEmpty() || modified.result().isEmpty()) {
            return null;
        }
        JsonArray originalMoves = ((JsonElement)original.result().get()).getAsJsonObject().getAsJsonArray("moves");
        JsonArray modifiedMoves = ((JsonElement)modified.result().get()).getAsJsonObject().getAsJsonArray("moves");
        List<Pair<Component, Map<String, Object>>> flattenedOriginal = JCraftChangesCommand.flattenAndGetName(originalMoves);
        List<Pair<Component, Map<String, Object>>> flattenedModified = JCraftChangesCommand.flattenAndGetName(modifiedMoves);
        return Streams.zip(flattenedOriginal.stream(), flattenedModified.stream(), Pair::of).map(p -> Pair.of((Object)((Component)((Pair)p.getFirst()).getFirst()), (Object)Maps.difference((Map)((Map)((Pair)p.getFirst()).getSecond()), (Map)((Map)((Pair)p.getSecond()).getSecond())))).toList();
    }

    private static List<Pair<Component, Map<String, Object>>> flattenAndGetName(JsonArray moves) {
        return moves.asList().stream().map(JsonElement::getAsJsonObject).map(obj -> {
            JsonObject jsonName = Optional.ofNullable(obj.getAsJsonObject("move")).flatMap(obj1 -> Optional.ofNullable(obj1.getAsJsonObject("extras"))).map(obj1 -> obj1.getAsJsonObject("name")).orElseGet(JsonObject::new);
            DataResult nameRes = ExtraCodecs.f_252442_.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonName);
            Component name = nameRes.result().map(Pair::getFirst).orElse((Component)Component.m_237113_((String)"ERROR"));
            return Pair.of((Object)name, JCraftChangesCommand.flatten(JCraftChangesCommand.asMap(obj)));
        }).toList();
    }

    private static Map<String, Object> flatten(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(JCraftChangesCommand::flatten).collect(LinkedHashMap::new, (m, e) -> m.put("/" + (String)e.getKey(), e.getValue()), HashMap::putAll);
    }

    private static Stream<Map.Entry<String, Object>> flatten(Map.Entry<String, Object> entry) {
        if (entry == null) {
            return Stream.empty();
        }
        if (entry.getValue() instanceof Map) {
            return ((Map)entry.getValue()).entrySet().stream().flatMap(e -> JCraftChangesCommand.flatten(new AbstractMap.SimpleEntry((CallSite)((Object)((String)entry.getKey() + "/" + String.valueOf(e.getKey()))), e.getValue())));
        }
        Object object = entry.getValue();
        if (object instanceof List) {
            List list = (List)object;
            return IntStream.range(0, list.size()).mapToObj(i -> new AbstractMap.SimpleEntry((CallSite)((Object)((String)entry.getKey() + "/" + i)), list.get(i))).flatMap(JCraftChangesCommand::flatten);
        }
        return Stream.of(entry);
    }

    private static Object toObject(JsonElement element) {
        if (element.isJsonObject()) {
            return JCraftChangesCommand.asMap(element.getAsJsonObject());
        }
        if (element.isJsonArray()) {
            return JCraftChangesCommand.asList(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            return JCraftChangesCommand.asPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonNull()) {
            return null;
        }
        return element;
    }

    private static Map<String, Object> asMap(JsonObject obj) {
        return obj.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)JCraftChangesCommand.toObject((JsonElement)entry.getValue()))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> a, LinkedHashMap::new));
    }

    private static List<Object> asList(JsonArray arr) {
        return arr.asList().stream().map(JCraftChangesCommand::toObject).collect(Collectors.toList());
    }

    private static Object asPrimitive(JsonPrimitive prim) {
        if (prim.isBoolean()) {
            return prim.getAsBoolean();
        }
        if (prim.isNumber()) {
            return prim.getAsNumber();
        }
        return prim.getAsString();
    }

    public static CompletableFuture<Void> onReload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        CHANGES = null;
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAccept(v -> {});
    }
}

