/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.common.argumenttype.SpecArgumentType;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SetSpecCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"spec").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"spec", (ArgumentType)SpecArgumentType.spec()).executes(SetSpecCommand::run)))));
    }

    public static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            SpecType specType = (SpecType)context.getArgument("spec", SpecType.class);
            Collection targets = EntityArgument.m_91461_(context, (String)"entities");
            if (targets.isEmpty()) {
                return 0;
            }
            for (Entity entity : targets) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                JComponentPlatformUtils.getSpecData(living).setType(specType);
            }
        }
        catch (Exception e) {
            JCraft.LOGGER.error("Failed to set spec", (Throwable)e);
            return 0;
        }
        return 1;
    }
}

