/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.common.argumenttype.StandArgumentType;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SetStandCommand {
    private static final DynamicCommandExceptionType INVALID_SKIN = new DynamicCommandExceptionType(s -> Component.m_237113_((String)("The given stand only has " + String.valueOf(s) + " skins.")));
    private static final SimpleCommandExceptionType EXCLUSIVE_STANDS_MULTIPLE_PLAYERS = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Cannot give multiple players the same stand as 'Exclusive Stands' is enabled."));
    private static final SimpleCommandExceptionType EXCLUSIVE_STANDS_STAND_TAKEN = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"That stand is already used by another player."));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        RandomSource rng = RandomSource.m_216327_();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"stand").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"stand", (ArgumentType)StandArgumentType.stand()).executes(ctx -> SetStandCommand.executeSet((CommandContext<CommandSourceStack>)ctx, (StandType)ctx.getArgument("stand", StandType.class), 0))).then(Commands.m_82129_((String)"skin", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(ctx -> SetStandCommand.executeSet((CommandContext<CommandSourceStack>)ctx, (StandType)ctx.getArgument("stand", StandType.class), (Integer)ctx.getArgument("skin", Integer.class)))))).then(Commands.m_82127_((String)"random").executes(ctx -> SetStandCommand.executeSet((CommandContext<CommandSourceStack>)ctx, 0, rng))))));
    }

    private static int executeSet(CommandContext<CommandSourceStack> ctx, int skin, RandomSource rng) throws CommandSyntaxException {
        return SetStandCommand.executeSet(ctx, null, skin, rng);
    }

    private static int executeSet(CommandContext<CommandSourceStack> ctx, StandType type, int skin) throws CommandSyntaxException {
        return SetStandCommand.executeSet(ctx, type, skin, null);
    }

    private static int executeSet(CommandContext<CommandSourceStack> ctx, StandType type, int skin, RandomSource rng) throws CommandSyntaxException {
        List<Player> playerTargets;
        int playerTargetCount;
        Collection targets = EntityArgument.m_91461_(ctx, (String)"targets");
        if (targets.isEmpty() || type == null && rng == null) {
            return 0;
        }
        if (type != null && skin >= type.getData().getInfo().getSkinCount()) {
            throw INVALID_SKIN.create((Object)type.getData().getInfo().getSkinCount());
        }
        if (JServerConfig.EXCLUSIVE_STANDS.getValue() && (playerTargetCount = (playerTargets = targets.stream().filter(e -> e instanceof Player).map(e -> (Player)e).toList()).size()) > 0) {
            if (playerTargetCount > 1) {
                throw EXCLUSIVE_STANDS_MULTIPLE_PLAYERS.create();
            }
            CommonStandComponent firstPlayerStandComp = JComponentPlatformUtils.getStandComponent((LivingEntity)playerTargets.get(0));
            if (firstPlayerStandComp.getType() != type && JCraft.getExclusiveStandsData().isStandUsed(type)) {
                throw EXCLUSIVE_STANDS_STAND_TAKEN.create();
            }
        }
        for (Entity entity : targets) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).m_6095_().m_204039_(JTagRegistry.CAN_NEVER_HAVE_STAND)) continue;
            CommonStandComponent standData = JComponentPlatformUtils.getStandComponent(livingEntity);
            if (type != null) {
                standData.setTypeAndSkin(type, skin);
            } else {
                standData.setType(StandTypeUtil.getRandom(rng));
            }
            livingEntity.m_19877_();
            JCraft.summon(entity.m_9236_(), livingEntity);
        }
        return 1;
    }
}

