/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.arna.jcraft.api.component.living.CommonGravityShiftComponent;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.attack.moves.cmoon.GravityShiftMove;
import net.arna.jcraft.common.entity.projectile.BlockProjectile;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class CommonGravityShiftComponentImpl
implements CommonGravityShiftComponent {
    public static final String GRAVITY_SOURCE = "jcraft$" + GravityShiftMove.class.getSimpleName();
    protected static final int RANGE_SQR = 10000;
    private final LivingEntity user;
    private final RandomSource random;
    private final List<Entity> shiftedEntities = new ArrayList<Entity>();
    protected int time = 0;
    private Vec3 particleDirection = Vec3.f_82478_;
    private ShiftType type = ShiftType.NONE;

    public CommonGravityShiftComponentImpl(LivingEntity user) {
        this.user = user;
        this.random = RandomSource.m_216327_();
    }

    public void tick() {
        if (this.time <= 0) {
            return;
        }
        --this.time;
        Level world = this.user.m_9236_();
        Vec3 pos = this.user.m_20182_();
        if (world.f_46443_) {
            for (int h = 0; h < 256; ++h) {
                Vec3 vel = Vec3.f_82478_;
                double x = pos.f_82479_ + this.random.m_216328_(0.0, 100.0);
                double y = pos.f_82480_ + this.random.m_216328_(0.0, 10.0);
                double z = pos.f_82481_ + this.random.m_216328_(0.0, 100.0);
                switch (this.type.ordinal()) {
                    case 1: {
                        vel = this.particleDirection;
                        break;
                    }
                    case 3: {
                        vel = new Vec3(x, y, z).m_82546_(pos);
                        break;
                    }
                    case 2: {
                        vel = pos.m_82492_(x, y, z);
                    }
                }
                world.m_7106_((ParticleOptions)ParticleTypes.f_123789_, x, y, z, vel.f_82479_, vel.f_82480_, vel.f_82481_);
            }
        } else if (this.type == ShiftType.DIRECTIONAL) {
            if (this.time < 1 && !this.shiftedEntities.isEmpty()) {
                this.shiftedEntities.clear();
            } else {
                for (Entity entity : this.shiftedEntities) {
                    if (entity.m_20280_((Entity)this.user) > 10000.0) {
                        GravityChangerAPI.setGravity(entity, GravityChangerAPI.getGravityList(entity).stream().filter(g -> !GRAVITY_SOURCE.equals(g.source())).toList());
                    }
                    entity.m_183634_();
                }
            }
        } else {
            if (this.user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
                return;
            }
            List toCatch = world.m_6443_(Entity.class, this.user.m_20191_().m_82400_(64.0), EntitySelector.f_20406_);
            for (Entity entity : toCatch) {
                BlockProjectile block;
                if (entity.m_20365_((Entity)this.user) || entity instanceof BlockProjectile && (block = (BlockProjectile)entity).getMaster() == this.user) continue;
                if (this.type == ShiftType.RADIAL_ATTRACT) {
                    entity.m_20256_(entity.m_20184_().m_82549_(entity.m_20182_().m_82546_(pos).m_82541_().m_82490_(0.1)));
                } else {
                    entity.m_20256_(entity.m_20184_().m_82549_(pos.m_82546_(entity.m_20182_()).m_82541_().m_82490_(0.1)));
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                    serverPlayerEntity.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayerEntity));
                }
                entity.f_19864_ = true;
            }
        }
    }

    @Override
    public void startRadial() {
        this.time = 200;
        this.type = ShiftType.RADIAL_ATTRACT;
        this.sync((Entity)this.user);
    }

    @Override
    public void startDirectional() {
        this.time = 600;
        this.type = ShiftType.DIRECTIONAL;
        Direction lookDir = JUtils.getLookDirection((Entity)this.user);
        List toCatch = this.user.m_9236_().m_6443_(Entity.class, this.user.m_20191_().m_82400_(16.0), EntitySelector.f_20406_.and(e -> !e.m_20365_((Entity)this.user)));
        Gravity gravity = new Gravity(lookDir, 3, 600, GRAVITY_SOURCE);
        this.shiftedEntities.clear();
        for (Entity entity : toCatch) {
            this.shiftedEntities.add(entity);
            GravityChangerAPI.addGravity(entity, gravity);
        }
        this.particleDirection = new Vec3(lookDir.m_253071_());
        this.sync((Entity)this.user);
    }

    @Override
    public boolean isActive() {
        return this.time > 0;
    }

    @Override
    public void swapRadialType() {
        if (this.type == ShiftType.DIRECTIONAL) {
            return;
        }
        this.type = this.type == ShiftType.RADIAL_ATTRACT ? ShiftType.RADIAL_REPULSE : ShiftType.RADIAL_ATTRACT;
        this.sync((Entity)this.user);
    }

    @Override
    public void stop() {
        this.time = 0;
        this.type = null;
        this.sync((Entity)this.user);
    }

    public void sync(Entity entity) {
    }

    public boolean shouldSyncWith(ServerPlayer player) {
        return !(player.m_20280_((Entity)this.user) > 10000.0);
    }

    private static Vec3 vecFromArray(int[] arr) {
        return new Vec3((double)arr[0], (double)arr[1], (double)arr[2]);
    }

    public void readFromNbt(CompoundTag tag) {
        this.time = tag.m_128451_("Time");
        this.type = ShiftType.fromId(tag.m_128451_("Type"));
        this.particleDirection = CommonGravityShiftComponentImpl.vecFromArray(tag.m_128465_("Direction"));
    }

    public void writeToNbt(CompoundTag tag) {
        tag.m_128405_("Time", this.time);
        tag.m_128405_("Type", this.type.ordinal());
        tag.m_128385_("Direction", new int[]{(int)this.particleDirection.f_82479_, (int)this.particleDirection.f_82480_, (int)this.particleDirection.f_82481_});
    }

    private static enum ShiftType {
        NONE,
        DIRECTIONAL,
        RADIAL_REPULSE,
        RADIAL_ATTRACT;


        @NonNull
        public static ShiftType fromId(int id) {
            switch (id) {
                default: {
                    return NONE;
                }
                case 1: {
                    return DIRECTIONAL;
                }
                case 2: {
                    return RADIAL_REPULSE;
                }
                case 3: 
            }
            return RADIAL_ATTRACT;
        }
    }
}

