/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl;

import net.arna.jcraft.api.component.living.CommonVampireComponent;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.common.spec.VampireSpec;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;

public abstract class CommonVampireComponentImpl
implements CommonVampireComponent {
    private final LivingEntity entity;
    private final Player player;
    private FoodData hungerManager = null;
    private boolean isVampire = false;
    private float blood = 20.0f;
    private byte healCount = 0;
    private int regenTick = 0;
    private int starveTick = 0;
    public static final int MIN_REGEN_BLOOD = 16;

    public CommonVampireComponentImpl(LivingEntity entity) {
        this.entity = entity;
        if (entity instanceof Player) {
            Player playerEntity;
            this.player = playerEntity = (Player)entity;
            this.hungerManager = playerEntity.m_36324_();
        } else {
            this.player = null;
        }
    }

    public void tick() {
        Level world = this.entity.m_9236_();
        if (world.f_46443_) {
            return;
        }
        if (this.player != null) {
            JSpec<?, ?> spec = JUtils.getSpec((LivingEntity)this.player);
            this.setVampire(spec != null && spec.getType() == JSpecTypeRegistry.VAMPIRE.get());
        }
        if (!this.isVampire) {
            return;
        }
        if (world.m_46461_() && !world.m_46471_() && !world.m_46470_() && !this.entity.m_6844_(EquipmentSlot.HEAD).m_204117_(JTagRegistry.PROTECTS_FROM_SUN) && world.m_45527_(this.entity.m_20183_())) {
            this.entity.m_20254_(1);
            this.entity.m_6469_(world.m_269111_().m_269483_(), 2.0f);
        }
        this.entity.m_20301_(this.entity.m_6062_());
        if (this.player != null) {
            if (this.blood < 1.0f && --this.starveTick < 1) {
                this.player.m_6469_(world.m_269111_().m_269064_(), 1.0f);
                this.starveTick = 80;
            } else {
                float health = this.entity.m_21223_();
                if (health < this.entity.m_21233_() && this.blood >= 16.0f && --this.regenTick < 1) {
                    this.player.m_5634_(1.0f);
                    this.healCount = (byte)(this.healCount + 1);
                    if (this.healCount > 2) {
                        this.blood -= 1.0f;
                        this.healCount = 0;
                    }
                    this.regenTick = 10;
                }
            }
        }
        if (this.hungerManager == null) {
            if (this.player != null) {
                this.hungerManager = this.player.m_36324_();
            }
        } else {
            if (this.hungerManager.m_150380_() > 32.0f) {
                this.hungerManager.m_38703_(-32.0f);
                this.setBlood(this.blood - 1.0f);
            }
            this.hungerManager.m_38705_(20);
            this.hungerManager.m_38717_(0.0f);
        }
    }

    @Override
    public void setBlood(float blood) {
        this.blood = Mth.m_14036_((float)blood, (float)0.0f, (float)20.0f);
        this.sync((Entity)this.entity);
    }

    @Override
    public boolean isVampire() {
        return this.isVampire || this.player != null && JUtils.getSpec((LivingEntity)this.player) instanceof VampireSpec;
    }

    @Override
    public void setVampire(boolean b) {
        if (b == this.isVampire) {
            return;
        }
        this.isVampire = b;
        this.sync((Entity)this.entity);
    }

    public void sync(Entity entity) {
    }

    public boolean shouldSyncWith(ServerPlayer player) {
        return player == this.entity;
    }

    public void writeSyncPacket(FriendlyByteBuf buf, ServerPlayer recipient) {
        buf.writeFloat(this.blood);
        buf.writeBoolean(this.isVampire);
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        this.blood = buf.readFloat();
        this.isVampire = buf.readBoolean();
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        this.blood = tag.m_128457_("Blood");
        this.isVampire = tag.m_128471_("Vampire");
    }

    @Override
    public void writeToNbt(CompoundTag tag) {
        tag.m_128350_("Blood", this.blood);
        tag.m_128379_("Vampire", this.isVampire);
    }

    @Override
    public float getBlood() {
        return this.blood;
    }
}

