/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.entity;

import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.component.entity.CommonGrabComponent;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public abstract class CommonGrabComponentImpl
implements CommonGrabComponent {
    private final Entity grabbed;
    public Entity attacker = null;
    public int duration = 0;
    private double distance;
    private double verticalOffset = 0.4;

    public CommonGrabComponentImpl(Entity grabbed) {
        this.grabbed = grabbed;
    }

    @Override
    public void startGrab(Entity attacker, int duration, double distance) {
        this.startGrab(attacker, duration, distance, 0.4);
    }

    @Override
    public void startGrab(Entity attacker, int duration, double distance, double verticalOffset) {
        if (attacker == null) {
            JCraft.LOGGER.warn(String.format("Null attacker tried to grab: %s", this.grabbed));
            return;
        }
        this.attacker = attacker;
        this.duration = duration;
        this.distance = distance;
        this.verticalOffset = verticalOffset;
        this.sync(this.grabbed);
    }

    @Override
    public void endGrab() {
        this.attacker = null;
        this.duration = 0;
        this.sync(this.grabbed);
    }

    public void tick() {
        if (this.attacker != null) {
            LivingEntity living;
            MobEffectInstance stun;
            Entity entity = this.grabbed;
            if (entity instanceof LivingEntity && (stun = (living = (LivingEntity)entity).m_21124_((MobEffect)JStatusRegistry.DAZED.get())) != null && stun.m_19564_() == StunType.LAUNCH.ordinal()) {
                this.endGrab();
                return;
            }
            if (this.attacker.m_6084_() && this.duration-- > 0) {
                Direction gravity = GravityChangerAPI.getGravityDirection(this.attacker);
                Vec3 newPos = this.attacker.m_20182_().m_82549_(RotationUtil.vecPlayerToWorld(new Vec3(0.0, this.verticalOffset, 0.0), gravity)).m_82549_(this.attacker.m_20154_().m_82490_(this.distance));
                if (!this.attacker.m_9236_().m_46575_(BlockPos.m_274446_((Position)newPos), this.grabbed)) {
                    Entity entity2 = this.grabbed;
                    if (entity2 instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity2;
                        serverPlayer.m_6021_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                    } else {
                        this.grabbed.m_146884_(newPos);
                    }
                }
                this.grabbed.m_20256_(Vec3.f_82478_);
            } else {
                this.endGrab();
            }
        }
    }

    public void sync(Entity entity) {
    }

    public boolean shouldSyncWith(ServerPlayer player) {
        return player.m_20280_(this.grabbed) <= 6400.0;
    }

    public void writeSyncPacket(FriendlyByteBuf buf, ServerPlayer recipient) {
        boolean notGrabbing = this.attacker == null;
        buf.writeBoolean(notGrabbing);
        if (notGrabbing) {
            return;
        }
        buf.m_130130_(this.attacker.m_19879_());
        buf.m_130130_(this.duration);
        buf.writeDouble(this.distance);
        buf.writeDouble(this.verticalOffset);
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.attacker = null;
            this.duration = 0;
            return;
        }
        this.attacker = this.grabbed.m_9236_().m_6815_(buf.m_130242_());
        this.duration = buf.m_130242_();
        this.distance = buf.readDouble();
        this.verticalOffset = buf.readDouble();
    }

    @Override
    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
    }

    @Override
    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
    }

    @Override
    public Entity getGrabbed() {
        return this.grabbed;
    }

    @Override
    public Entity getAttacker() {
        return this.attacker;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }
}

