/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import net.arna.jcraft.api.component.entity.CommonGravityComponent;
import net.arna.jcraft.common.gravity.RotationAnimation;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.gravity.util.EntityTags;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.arna.jcraft.common.gravity.util.GravityChannel;
import net.arna.jcraft.common.gravity.util.NetworkUtil;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CommonGravityComponentImpl
implements CommonGravityComponent {
    private Direction gravityDirection = Direction.DOWN;
    private Direction defaultGravityDirection = Direction.DOWN;
    private Direction prevGravityDirection = Direction.DOWN;
    private boolean isInverted = false;
    private final RotationAnimation animation = new RotationAnimation();
    private boolean needsInitialSync = false;
    private List<Gravity> gravityList = new ArrayList<Gravity>();
    private final Entity entity;

    public CommonGravityComponentImpl(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void onGravityChanged(Direction oldGravity, Direction newGravity, RotationParameters rotationParameters, boolean initialGravity) {
        this.entity.f_19789_ = 0.0f;
        this.entity.m_146884_(this.entity.m_20182_());
        if (initialGravity) {
            return;
        }
        if (!(this.entity instanceof ServerPlayer)) {
            Vec3 relativeRotationCentre = this.getCentreOfRotation(oldGravity, newGravity, rotationParameters);
            Vec3 translation = RotationUtil.vecPlayerToWorld(relativeRotationCentre, oldGravity).m_82546_(RotationUtil.vecPlayerToWorld(relativeRotationCentre, newGravity));
            Direction relativeDirection = RotationUtil.dirWorldToPlayer(newGravity, oldGravity);
            Vec3 smidge = new Vec3(relativeDirection == Direction.EAST ? -1.0E-6 : 0.0, relativeDirection == Direction.UP ? -1.0E-6 : 0.0, relativeDirection == Direction.SOUTH ? -1.0E-6 : 0.0);
            smidge = RotationUtil.vecPlayerToWorld(smidge, oldGravity);
            this.entity.m_146884_(this.entity.m_20182_().m_82549_(translation).m_82549_(smidge));
            if (this.shouldChangeVelocity() && !rotationParameters.alternateCenter()) {
                this.adjustEntityPosition(oldGravity);
            }
        }
        if (!this.shouldChangeVelocity()) {
            return;
        }
        Vec3 realWorldVelocity = this.getRealWorldVelocity(this.entity, this.prevGravityDirection);
        if (rotationParameters.rotateVelocity()) {
            Vector3f worldSpaceVec = realWorldVelocity.m_252839_();
            worldSpaceVec.rotate((Quaternionfc)RotationUtil.getRotationBetween(this.prevGravityDirection, this.gravityDirection));
            this.entity.m_20256_(RotationUtil.vecWorldToPlayer(new Vec3(worldSpaceVec), this.gravityDirection));
        } else {
            this.entity.m_20256_(RotationUtil.vecWorldToPlayer(realWorldVelocity, this.gravityDirection));
        }
    }

    private Vec3 getRealWorldVelocity(Entity entity, Direction prevGravityDirection) {
        if (entity.m_6109_()) {
            return new Vec3(entity.m_20185_() - entity.f_19854_, entity.m_20186_() - entity.f_19855_, entity.m_20189_() - entity.f_19856_);
        }
        return RotationUtil.vecPlayerToWorld(entity.m_20184_(), prevGravityDirection);
    }

    private boolean shouldChangeVelocity() {
        if (this.entity instanceof FishingHook) {
            return true;
        }
        if (this.entity instanceof FireworkRocketEntity) {
            return true;
        }
        return !(this.entity instanceof Projectile);
    }

    @NonNull
    private Vec3 getCentreOfRotation(Direction oldGravity, Direction newGravity, RotationParameters rotationParameters) {
        Vec3 relativeRotationCentre = Vec3.f_82478_;
        if (this.entity instanceof EndCrystal) {
            relativeRotationCentre = new Vec3(0.0, -0.5, 0.0);
        } else if (rotationParameters.alternateCenter()) {
            EntityDimensions dimensions = this.entity.m_6972_(this.entity.m_20089_());
            relativeRotationCentre = newGravity.m_122424_() == oldGravity ? new Vec3(0.0, (double)(dimensions.f_20378_ / 2.0f), 0.0) : new Vec3(0.0, (double)(dimensions.f_20377_ / 2.0f), 0.0);
        }
        return relativeRotationCentre;
    }

    private void adjustEntityPosition(Direction oldGravity) {
        if (this.entity instanceof AreaEffectCloud || this.entity instanceof AbstractArrow || this.entity instanceof EndCrystal) {
            return;
        }
        AABB entityBoundingBox = this.entity.m_20191_();
        Direction movingDirection = oldGravity.m_122424_();
        Iterable collisions = this.entity.m_9236_().m_186431_(this.entity, entityBoundingBox);
        AABB totalCollisionBox = null;
        for (VoxelShape collision : collisions) {
            if (collision.m_83281_()) continue;
            AABB boundingBox = collision.m_83215_();
            if (totalCollisionBox == null) {
                totalCollisionBox = boundingBox;
                continue;
            }
            totalCollisionBox = totalCollisionBox.m_82367_(boundingBox);
        }
        if (totalCollisionBox != null) {
            this.entity.m_146884_(this.entity.m_20182_().m_82549_(CommonGravityComponentImpl.getPositionAdjustmentOffset(entityBoundingBox, totalCollisionBox, movingDirection)));
        }
    }

    private static Vec3 getPositionAdjustmentOffset(AABB entityBoundingBox, AABB nearbyCollisionUnion, Direction movingDirection) {
        Direction.Axis axis = movingDirection.m_122434_();
        double offset = 0.0;
        if (movingDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            double pushed;
            double pushing = nearbyCollisionUnion.m_82374_(axis);
            if (pushing > (pushed = entityBoundingBox.m_82340_(axis))) {
                offset = pushing - pushed;
            }
        } else {
            double pushed;
            double pushing = nearbyCollisionUnion.m_82340_(axis);
            if (pushing < (pushed = entityBoundingBox.m_82374_(axis))) {
                offset = pushed - pushing;
            }
        }
        return new Vec3(movingDirection.m_253071_()).m_82490_(offset);
    }

    @Override
    public Direction getGravityDirection() {
        if (this.canChangeGravity()) {
            return this.gravityDirection;
        }
        return Direction.DOWN;
    }

    private boolean canChangeGravity() {
        return EntityTags.canChangeGravity(this.entity);
    }

    @Override
    public Direction getPrevGravityDirection() {
        if (this.canChangeGravity()) {
            return this.prevGravityDirection;
        }
        return Direction.DOWN;
    }

    @Override
    public Direction getDefaultGravityDirection() {
        if (this.canChangeGravity()) {
            return this.defaultGravityDirection;
        }
        return Direction.DOWN;
    }

    @Override
    public void updateGravity(RotationParameters rotationParameters, boolean initialGravity) {
        Direction newGravity;
        Direction oldGravity;
        if (this.canChangeGravity() && (oldGravity = this.gravityDirection) != (newGravity = this.getActualGravityDirection())) {
            long timeMs = this.entity.m_9236_().m_46467_() * 50L;
            if (this.entity.m_9236_().f_46443_) {
                this.animation.applyRotationAnimation(newGravity, oldGravity, initialGravity ? 0L : (long)rotationParameters.rotationTime(), this.entity, timeMs, rotationParameters.rotateView());
            }
            this.prevGravityDirection = oldGravity;
            this.gravityDirection = newGravity;
            this.onGravityChanged(oldGravity, newGravity, rotationParameters, initialGravity);
        }
    }

    @Override
    public Direction getActualGravityDirection() {
        Direction newGravity = this.getDefaultGravityDirection();
        Gravity highestPriority = this.getHighestPriority();
        if (highestPriority != null) {
            newGravity = highestPriority.direction();
        }
        if (this.isInverted) {
            newGravity = newGravity.m_122424_();
        }
        return newGravity;
    }

    @Nullable
    private Gravity getHighestPriority() {
        return !this.gravityList.isEmpty() ? Collections.max(this.gravityList, Comparator.comparingInt(Gravity::priority)) : null;
    }

    @Override
    public void setDefaultGravityDirection(Direction gravityDirection, RotationParameters rotationParameters, boolean initialGravity) {
        if (this.canChangeGravity()) {
            this.defaultGravityDirection = gravityDirection;
            this.updateGravity(rotationParameters, initialGravity);
        }
    }

    @Override
    public void addGravity(Gravity gravity, boolean initialGravity) {
        if (this.canChangeGravity()) {
            this.gravityList.removeIf(g -> Objects.equals(g.source(), gravity.source()));
            if (gravity.direction() != null) {
                this.gravityList.add(new Gravity(gravity));
            }
            this.updateGravity(gravity.rotationParameters(), initialGravity);
        }
    }

    @Override
    public List<Gravity> getGravity() {
        return this.gravityList;
    }

    @Override
    public void setGravity(List<Gravity> _gravityList, boolean initialGravity) {
        Gravity highestBefore = this.getHighestPriority();
        this.gravityList = new ArrayList<Gravity>(_gravityList);
        Gravity highestAfter = this.getHighestPriority();
        if (highestBefore == highestAfter) {
            return;
        }
        if (highestBefore == null) {
            this.updateGravity(highestAfter.rotationParameters(), initialGravity);
        } else if (highestAfter == null) {
            this.updateGravity(highestBefore.rotationParameters(), initialGravity);
        } else if (highestBefore.priority() > highestAfter.priority()) {
            this.updateGravity(highestBefore.rotationParameters(), initialGravity);
        } else {
            this.updateGravity(highestAfter.rotationParameters(), initialGravity);
        }
    }

    @Override
    public void invertGravity(boolean _isInverted, RotationParameters rotationParameters, boolean initialGravity) {
        this.isInverted = _isInverted;
        this.updateGravity(rotationParameters, initialGravity);
    }

    @Override
    public boolean getInvertGravity() {
        return this.isInverted;
    }

    @Override
    public void clearGravity(RotationParameters rotationParameters, boolean initialGravity) {
        this.gravityList.clear();
        this.updateGravity(rotationParameters, initialGravity);
    }

    @Override
    public RotationAnimation getGravityAnimation() {
        return this.animation;
    }

    public void readFromNbt(CompoundTag nbt) {
        Direction oldDefaultGravity = this.defaultGravityDirection;
        List<Gravity> oldList = this.gravityList;
        boolean oldIsInverted = this.isInverted;
        if (nbt.m_128425_("ListSize", 3)) {
            int listSize = nbt.m_128451_("ListSize");
            ArrayList<Gravity> newGravityList = new ArrayList<Gravity>();
            if (listSize != 0) {
                for (int index = 0; index < listSize; ++index) {
                    Gravity newGravity = new Gravity(Direction.m_122376_((int)nbt.m_128451_("GravityDirection " + index)), nbt.m_128451_("GravityPriority " + index), nbt.m_128451_("GravityDuration " + index), nbt.m_128461_("GravitySource " + index));
                    newGravityList.add(newGravity);
                }
            }
            this.gravityList = newGravityList;
        }
        this.prevGravityDirection = Direction.m_122376_((int)nbt.m_128451_("PrevGravityDirection"));
        this.defaultGravityDirection = Direction.m_122376_((int)nbt.m_128451_("DefaultGravityDirection"));
        this.isInverted = nbt.m_128471_("IsGravityInverted");
        RotationParameters rp = new RotationParameters(false, false, false, 0);
        this.updateGravity(rp, true);
        if (oldDefaultGravity != this.defaultGravityDirection) {
            this.needsInitialSync = true;
        }
        if (oldList.isEmpty() != this.gravityList.isEmpty()) {
            this.needsInitialSync = true;
        }
        if (oldIsInverted != this.isInverted) {
            this.needsInitialSync = true;
        }
    }

    public void writeToNbt(@NonNull CompoundTag nbt) {
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        int index = 0;
        for (Gravity temp : this.getGravity()) {
            if (temp.direction() == null || temp.source() == null) continue;
            nbt.m_128405_("GravityDirection " + index, temp.direction().m_122411_());
            nbt.m_128405_("GravityPriority " + index, temp.priority());
            nbt.m_128405_("GravityDuration " + index, temp.duration());
            nbt.m_128359_("GravitySource " + index, temp.source());
            ++index;
        }
        nbt.m_128405_("ListSize", index);
        nbt.m_128405_("PrevGravityDirection", this.getPrevGravityDirection().m_122411_());
        nbt.m_128405_("DefaultGravityDirection", this.getDefaultGravityDirection().m_122411_());
        nbt.m_128379_("IsGravityInverted", this.getInvertGravity());
    }

    public void tick() {
        Entity vehicle = this.entity.m_20202_();
        if (vehicle != null) {
            this.addGravity(new Gravity(GravityChangerAPI.getGravityDirection(vehicle), 99999999, 2, "vehicle"), true);
        }
        List<Gravity> gravityList = this.getGravity();
        Gravity highestBefore = this.getHighestPriority();
        if (gravityList.removeIf(g -> g.duration() == 0)) {
            if (highestBefore != null) {
                this.updateGravity(highestBefore.rotationParameters(), false);
            } else {
                this.updateGravity(new RotationParameters(false, false, false, 0), true);
            }
        }
        for (Gravity temp : gravityList) {
            if (temp.duration() <= 0) continue;
            temp.decrementDuration();
        }
        if (!this.entity.m_9236_().f_46443_ && this.needsInitialSync) {
            this.needsInitialSync = false;
            RotationParameters rotationParameters = new RotationParameters(false, false, false, 0);
            GravityChannel.sendFullStatePacket(this.entity, NetworkUtil.PacketMode.EVERYONE, rotationParameters, true);
        }
    }
}

