/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.entity;

import lombok.NonNull;
import net.arna.jcraft.api.component.entity.CommonTimeStopComponent;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class CommonTimeStopComponentImpl
implements CommonTimeStopComponent {
    private final Entity entity;
    private int ticks;
    private Vec3 totalVelocity = Vec3.f_82478_;

    public CommonTimeStopComponentImpl(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void setTicks(int ticks) {
        if (this.ticks <= 0) {
            this.totalVelocity = Vec3.f_82478_;
        }
        this.ticks = ticks;
        this.sync(this.entity);
    }

    public void sync(Entity entity) {
    }

    @Override
    public void addTotalVelocity(Vec3 vel) {
        this.totalVelocity = this.totalVelocity.m_82549_(vel);
    }

    @Override
    public void tick(CallbackInfo ci) {
        if (this.ticks <= 0) {
            return;
        }
        JUtils.stopTick(this.entity);
        for (Entity passenger : this.entity.m_20197_()) {
            JUtils.stopTick(passenger);
        }
        --this.ticks;
        if (this.ticks == 0 && this.totalVelocity.m_82556_() > 0.01) {
            Vec3i localUp = GravityChangerAPI.getGravityDirection(this.entity).m_122424_().m_122436_();
            double upX = this.entity.m_20185_() + (double)localUp.m_123341_() * 0.1;
            double upY = this.entity.m_20186_() + (double)localUp.m_123342_() * 0.1;
            double upZ = this.entity.m_20189_() + (double)localUp.m_123343_() * 0.1;
            this.entity.m_20324_(upX, upY, upZ);
            this.entity.m_6853_(false);
            JUtils.addVelocity(this.entity, this.totalVelocity.f_82479_, this.totalVelocity.f_82480_, this.totalVelocity.f_82481_);
        }
        ci.cancel();
    }

    @Override
    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.ticks = tag.m_128451_("Ticks");
    }

    @Override
    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        tag.m_128405_("Ticks", this.ticks);
    }

    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }

    public Vec3 getTotalVelocity() {
        return this.totalVelocity;
    }
}

