/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.living;

import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonBombTrackerComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class CommonBombTrackerComponentImpl
implements CommonBombTrackerComponent {
    private final Entity entity;
    public final CommonBombTrackerComponent.BombData main = new CommonBombTrackerComponent.BombData();
    public final CommonBombTrackerComponent.BombData btd = new CommonBombTrackerComponent.BombData();

    public CommonBombTrackerComponentImpl(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        this.entity = entity;
    }

    @Override
    public CommonBombTrackerComponent.BombData getMainBomb() {
        return this.main;
    }

    @Override
    @Deprecated
    public CommonBombTrackerComponent.BombData getBTD() {
        return this.btd;
    }

    public void tick() {
        Level world = this.entity.m_9236_();
        if (world.f_46443_) {
            Entity entity;
            int id = this.getMainBomb().bombEntityID;
            if (this.getMainBomb().bombEntity == null && id != -1 && (entity = world.m_6815_(id)) != null) {
                this.getMainBomb().bombEntity = entity;
            }
            JCraft.getClientEntityHandler().bombTrackerParticleTick(this.entity, this.main);
        } else if (this.main.dirty) {
            this.sync(this.entity);
        }
    }

    public void sync(Entity entity) {
        this.main.dirty = false;
        this.btd.dirty = false;
    }

    public boolean shouldSyncWith(ServerPlayer player) {
        return player == this.entity;
    }

    public void syncBombData(FriendlyByteBuf buf, CommonBombTrackerComponent.BombData bombData) {
        buf.writeBoolean(bombData.isBlock);
        buf.writeBoolean(bombData.isEntity);
        buf.writeBoolean(bombData.isItem);
        if (bombData.isEntity) {
            buf.m_130130_(bombData.bombEntity.m_19879_());
        }
        if (bombData.isBlock) {
            buf.m_130064_(bombData.bombBlock);
        }
    }

    public void writeSyncPacket(FriendlyByteBuf buf, ServerPlayer recipient) {
        this.syncBombData(buf, this.main);
    }

    public void readBombData(FriendlyByteBuf buf, CommonBombTrackerComponent.BombData bombData) {
        bombData.isBlock = buf.readBoolean();
        bombData.isEntity = buf.readBoolean();
        bombData.isItem = buf.readBoolean();
        if (bombData.isEntity) {
            int id;
            bombData.bombEntityID = id = buf.m_130242_();
            bombData.bombEntity = this.entity.m_9236_().m_6815_(id);
        }
        if (bombData.isBlock) {
            bombData.bombBlock = buf.m_130135_();
        }
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        this.readBombData(buf, this.main);
    }

    @Override
    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
    }

    @Override
    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
    }
}

