/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.living;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class CommonCooldownsComponentImpl
implements CommonCooldownsComponent {
    public final Object2IntMap<CooldownType> cooldowns = new Object2IntRBTreeMap();
    protected final Object2IntMap<CooldownType> initialDurations = new Object2IntRBTreeMap();
    private final Entity entity;
    public boolean skipSync;

    public CommonCooldownsComponentImpl(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        this.entity = entity;
    }

    @Override
    public int getCooldown(CooldownType type) {
        return Math.max(this.cooldowns.getOrDefault((Object)type, 0), 0);
    }

    @Override
    public int getInitialDuration(CooldownType type) {
        return this.initialDurations.getOrDefault((Object)type, 0);
    }

    @Override
    public void setCooldown(CooldownType type, int duration) {
        if (duration == 0) {
            this.clear(type);
            return;
        }
        if (type.isOverrideNoCooldowns() || JServerConfig.ENABLE_MOVE_COOLDOWNS.getValue()) {
            duration = (int)((float)duration * JServerConfig.COOLDOWN_MULTIPLIER.getValue());
            this.cooldowns.put((Object)type, duration);
            this.initialDurations.put((Object)type, duration);
            this.sync(this.entity);
        }
    }

    @Override
    public void cooldownCancel() {
        CooldownType[] player;
        if (this.entity.m_5833_()) {
            return;
        }
        Entity entity = this.entity;
        if (entity instanceof Player && (player = (CooldownType[])entity).m_7500_()) {
            this.clear();
            return;
        }
        if (this.getCooldown(CooldownType.COOLDOWN_CANCEL) > 0) {
            return;
        }
        if (!JServerConfig.ENABLE_MOVE_COOLDOWNS.getValue()) {
            return;
        }
        this.skipSync = true;
        for (CooldownType type : CooldownType.values()) {
            if (type.isNonResettable()) continue;
            this.clear(type);
        }
        this.skipSync = false;
        this.startCooldown(CooldownType.COOLDOWN_CANCEL);
        Vec3 pPos = this.entity.m_146892_();
        this.entity.m_9236_().m_6269_(null, this.entity, (SoundEvent)JSoundRegistry.COOLDOWN_CANCEL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!this.entity.m_9236_().f_46443_) {
            JCraft.createParticle((ServerLevel)this.entity.m_9236_(), pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, JParticleType.COOLDOWN_CANCEL);
        }
        this.sync(this.entity);
    }

    @Override
    public void clear(CooldownType type) {
        this.cooldowns.put((Object)type, 0);
        this.initialDurations.put((Object)type, 0);
        this.sync(this.entity);
    }

    @Override
    public void clear() {
        this.skipSync = true;
        for (CooldownType type : CooldownType.values()) {
            this.clear(type);
        }
        this.skipSync = false;
        this.sync(this.entity);
    }

    public void sync(Entity entity) {
    }

    public void tick() {
        boolean isClient = this.entity.m_9236_().f_46443_;
        boolean shouldSync = false;
        for (Object2IntMap.Entry entry : this.cooldowns.object2IntEntrySet()) {
            if (isClient && entry.getIntValue() <= 1 || entry.getIntValue() <= 0) continue;
            entry.setValue(entry.getIntValue() - 1);
            if (isClient || entry.getIntValue() > 0) continue;
            shouldSync = true;
        }
        if (shouldSync) {
            this.sync(this.entity);
        }
    }

    @Override
    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        CommonCooldownsComponentImpl.readMap(this.cooldowns, tag.m_128469_("Cooldowns"));
        CommonCooldownsComponentImpl.readMap(this.initialDurations, tag.m_128469_("InitialDurations"));
    }

    private static void readMap(Object2IntMap<CooldownType> map, CompoundTag tag) {
        for (CooldownType type : CooldownType.values()) {
            if (tag.m_128425_(type.name(), 3)) {
                map.put((Object)type, tag.m_128451_(type.name()));
                continue;
            }
            map.removeInt((Object)type);
        }
    }

    @Override
    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        tag.m_128365_("Cooldowns", (Tag)CommonCooldownsComponentImpl.writeMap(this.cooldowns));
        tag.m_128365_("InitialDurations", (Tag)CommonCooldownsComponentImpl.writeMap(this.initialDurations));
    }

    private static CompoundTag writeMap(Object2IntMap<CooldownType> map) {
        CompoundTag nbt = new CompoundTag();
        map.object2IntEntrySet().forEach(entry -> {
            if (entry.getIntValue() > 0) {
                nbt.m_128405_(((CooldownType)((Object)((Object)entry.getKey()))).name(), entry.getIntValue());
            }
        });
        return nbt;
    }

    public boolean shouldSyncWith(ServerPlayer player) {
        return player == this.entity;
    }
}

