/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.living;

import java.util.Random;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class CommonHitPropertyComponentImpl
implements CommonHitPropertyComponent {
    protected final Entity entity;
    protected long endHitAnimTime = 0L;
    protected CommonHitPropertyComponent.HitAnimation hitAnimation = null;
    protected Vec3 randomRotation = Vec3.f_82478_;
    protected final Random random;

    public CommonHitPropertyComponentImpl(Entity entity) {
        this.entity = entity;
        this.random = new Random();
    }

    @Override
    public long endHitAnimTime() {
        return this.endHitAnimTime - this.entity.m_9236_().m_46467_();
    }

    @Override
    public void setHitAnimation(CommonHitPropertyComponent.HitAnimation hitAnimation, int duration) {
        this.hitAnimation = hitAnimation;
        this.endHitAnimTime = this.entity.m_9236_().m_46467_() + (long)duration;
        this.sync(this.entity);
    }

    public void tick() {
    }

    public void sync(Entity entity) {
    }

    public boolean shouldSyncWith(ServerPlayer player) {
        return player.m_20280_(this.entity) <= 6400.0;
    }

    public void writeSyncPacket(FriendlyByteBuf buf, ServerPlayer recipient) {
        buf.m_130103_(this.endHitAnimTime);
        if (this.endHitAnimTime > 0L) {
            buf.m_130130_(this.hitAnimation.ordinal());
        }
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        this.endHitAnimTime = buf.m_130258_();
        if (this.endHitAnimTime > 0L) {
            this.hitAnimation = CommonHitPropertyComponent.HitAnimation.values()[buf.m_130242_()];
        }
        this.randomRotation = new Vec3(this.random.nextGaussian(), this.random.nextGaussian(), this.random.nextGaussian());
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        if (tag.m_128456_()) {
            return;
        }
        this.endHitAnimTime = tag.m_128454_("EndTime");
        this.hitAnimation = CommonHitPropertyComponent.HitAnimation.values()[tag.m_128451_("AnimIndex")];
    }

    @Override
    public void writeToNbt(CompoundTag tag) {
        if (this.hitAnimation == null) {
            return;
        }
        tag.m_128356_("EndTime", this.endHitAnimTime);
        tag.m_128405_("AnimIndex", this.hitAnimation.ordinal());
    }

    @Override
    public CommonHitPropertyComponent.HitAnimation getHitAnimation() {
        return this.hitAnimation;
    }

    @Override
    public Vec3 getRandomRotation() {
        return this.randomRotation;
    }
}

