/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.living;

import java.util.UUID;
import lombok.NonNull;
import net.arna.jcraft.api.component.living.CommonMiscComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CommonMiscComponentImpl
implements CommonMiscComponent {
    private final Entity entity;
    private Vec3 desiredVelocity = Vec3.f_82478_;
    @Nullable
    private UUID slavedTo = null;
    private LivingEntity master = null;
    private int damageTimer;
    private int knifeTimer;
    private int stuckKnifeCount;
    private int armoredHitTicks;
    private int hoverTime;
    private boolean prevNoGrav;
    private float attackSpeedMult;
    private float metallicaIron = 80.0f;

    public CommonMiscComponentImpl(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void updateRemoteInputs(int forward, int sideways, boolean jumping) {
        Entity entity = this.entity;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Vec3 v = new Vec3((double)forward, 0.0, (double)sideways).m_82541_();
        Vec3 rotVec = player.m_20154_();
        rotVec = new Vec3(rotVec.f_82479_, 0.0, rotVec.f_82481_).m_82541_();
        float moveSpeed = player.m_6113_();
        this.desiredVelocity = rotVec.m_82490_(v.f_82479_ * (double)moveSpeed).m_82549_(rotVec.m_82524_(1.5707963f).m_82490_(v.f_82481_ * (double)moveSpeed));
        if (jumping && player.m_20096_()) {
            this.desiredVelocity = this.desiredVelocity.m_82520_(0.0, (double)(player.m_285755_() * 0.42f), 0.0);
        }
    }

    @Override
    public void setSlavedTo(UUID slavedTo) {
        this.slavedTo = slavedTo;
        this.sync(this.entity);
    }

    @Override
    public void startDamageTimer() {
        this.damageTimer = 1200;
        this.sync(this.entity);
    }

    @Override
    public boolean isOnDamageTimer() {
        return this.damageTimer > 0;
    }

    @Override
    public void setHoverTime(int hoverTime) {
        this.hoverTime = hoverTime;
    }

    @Override
    public boolean getPrevNoGrav() {
        return this.prevNoGrav;
    }

    @Override
    public void setPrevNoGrav(boolean prevNoGrav) {
        this.prevNoGrav = prevNoGrav;
    }

    @Override
    public void stab() {
        if (++this.stuckKnifeCount > 16) {
            this.stuckKnifeCount = 16;
        }
        this.updateKnifeTimer();
    }

    @Override
    public void displayArmoredHit() {
        this.entity.m_5496_((SoundEvent)JSoundRegistry.ARMORED_HIT.get(), 1.0f, 1.0f);
        this.armoredHitTicks = 10;
        this.sync(this.entity);
    }

    @Override
    public void setAttackSpeedMult(float speedMult) {
        this.attackSpeedMult = speedMult;
        this.sync(this.entity);
    }

    @Override
    public float getMetallicaIron() {
        return this.metallicaIron;
    }

    @Override
    public void setMetallicaIron(float iron) {
        this.metallicaIron = iron;
    }

    public void tick() {
        if (this.damageTimer > 0) {
            --this.damageTimer;
        }
        if (this.armoredHitTicks > 0) {
            --this.armoredHitTicks;
        }
        if (this.entity.m_9236_().m_5776_()) {
            return;
        }
        if (this.slavedTo != null) {
            if (this.master == null) {
                if (this.entity.f_19797_ % 20 == 0) {
                    this.master = this.entity.m_9236_().m_46003_(this.slavedTo);
                }
            } else {
                Entity entity = this.entity;
                if (entity instanceof Mob) {
                    LivingEntity victim;
                    Mob mob = (Mob)entity;
                    if (mob.m_5448_() == this.master) {
                        mob.m_6710_(null);
                    }
                    if ((victim = this.master.m_21214_()) == null) {
                        LivingEntity adv = this.master.m_21232_();
                        if (adv != null && adv.m_6084_()) {
                            mob.m_6710_(adv);
                        }
                    } else if (victim.m_6084_()) {
                        mob.m_6710_(victim);
                    }
                    if (mob.m_20280_(this.entity) > 256.0) {
                        mob.m_21573_().m_5624_(this.entity, 1.0);
                    }
                }
            }
        }
        if (this.stuckKnifeCount <= 0 && --this.knifeTimer <= 0) {
            --this.stuckKnifeCount;
            this.updateKnifeTimer();
        }
    }

    @Override
    public LivingEntity getMaster() {
        return this.master;
    }

    private void updateKnifeTimer() {
        this.knifeTimer = 20 * (30 - this.stuckKnifeCount);
        this.sync(this.entity);
    }

    public void sync(Entity entity) {
    }

    public boolean shouldSyncWith(ServerPlayer player) {
        return player.m_20280_(this.entity) <= 6400.0;
    }

    public void writeSyncPacket(FriendlyByteBuf buf, ServerPlayer recipient) {
        buf.m_130130_(this.armoredHitTicks);
        buf.m_130130_(this.stuckKnifeCount);
        buf.writeFloat(this.attackSpeedMult);
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        this.armoredHitTicks = buf.m_130242_();
        this.stuckKnifeCount = buf.m_130242_();
        this.attackSpeedMult = buf.readFloat();
    }

    @Override
    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        CompoundTag dvComp = tag.m_128469_("DesiredVelocity");
        this.desiredVelocity = new Vec3(dvComp.m_128459_("X"), dvComp.m_128459_("Y"), dvComp.m_128459_("Z"));
        this.damageTimer = tag.m_128451_("DamageTimer");
        this.metallicaIron = tag.m_128457_("MetallicaIron");
        if (tag.m_128403_("SlavedTo")) {
            this.slavedTo = tag.m_128342_("SlavedTo");
        }
    }

    @Override
    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        CompoundTag dvComp = new CompoundTag();
        dvComp.m_128347_("X", this.desiredVelocity.m_7096_());
        dvComp.m_128347_("Y", this.desiredVelocity.m_7098_());
        dvComp.m_128347_("Z", this.desiredVelocity.m_7094_());
        tag.m_128365_("DesiredVelocity", (Tag)dvComp);
        tag.m_128405_("DamageTimer", this.damageTimer);
        tag.m_128350_("MetallicaIron", this.metallicaIron);
        if (this.slavedTo != null) {
            tag.m_128362_("SlavedTo", this.slavedTo);
        }
    }

    @Override
    public Vec3 getDesiredVelocity() {
        return this.desiredVelocity;
    }

    @Override
    @Nullable
    public UUID getSlavedTo() {
        return this.slavedTo;
    }

    @Override
    public int getStuckKnifeCount() {
        return this.stuckKnifeCount;
    }

    @Override
    public int getArmoredHitTicks() {
        return this.armoredHitTicks;
    }

    @Override
    public int getHoverTime() {
        return this.hoverTime;
    }

    @Override
    public float getAttackSpeedMult() {
        return this.attackSpeedMult;
    }
}

