/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.living;

import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JAdvancementTriggerRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class CommonStandComponentImpl
implements CommonStandComponent {
    private final Entity entity;
    private StandEntity<?, ?> stand;
    private StandType type;
    private int skin;
    private boolean tagged;

    public CommonStandComponentImpl(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void setTypeAndSkin(@Nullable StandType type, int skin) {
        Entity entity;
        if (!this.entity.m_9236_().f_46443_ && this.entity instanceof Player && !JCraft.getExclusiveStandsData().switchStand(this.type, type)) {
            return;
        }
        if (!StandTypeUtil.isNone(type) && (entity = this.entity) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JAdvancementTriggerRegistry.OBTAINED_STAND.trigger(player, type);
        }
        this.type = type;
        this.skin = skin;
        this.sync(this.entity);
    }

    @Override
    public void setSkin(int skin) {
        if (this.type == null) {
            return;
        }
        this.skin = Mth.m_14045_((int)skin, (int)0, (int)(this.type.getData().getInfo().getSkinCount() - 1));
        this.sync(this.entity);
    }

    @Override
    public void setStand(@Nullable StandEntity<?, ?> stand) {
        this.stand = stand;
        this.sync(this.entity);
    }

    @Override
    @Nullable
    public StandType getType() {
        if (this.type == null && this.stand != null) {
            JCraft.LOGGER.warn("StandType of {} is null despite non-null stand {}", (Object)this.stand.getUser(), this.stand);
        }
        return this.type;
    }

    @Override
    @Nullable
    public StandEntity<?, ?> getStand() {
        StandEntity passenger;
        Entity entity;
        if (this.stand != null && !this.stand.m_6084_()) {
            this.setStand(null);
        }
        if ((entity = this.entity.m_146895_()) instanceof StandEntity && this.stand != (passenger = (StandEntity)entity)) {
            this.setStand(passenger);
        }
        return this.stand;
    }

    @Override
    public void setTagged(boolean tagged) {
        this.tagged = tagged;
        this.sync(this.entity);
    }

    public void sync(Entity entity) {
    }

    @Override
    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.type = StandTypeUtil.readFromNBT(tag, "Type");
        this.skin = tag.m_128451_("Skin");
        this.tagged = tag.m_128471_("Tagged");
    }

    @Override
    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        tag.m_128359_("Type", this.type == null ? "" : this.type.getId().toString());
        tag.m_128405_("Skin", this.skin);
        tag.m_128379_("Tagged", this.tagged);
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        Entity entity;
        Entity entity2 = entity = buf.readBoolean() ? this.entity.m_9236_().m_6815_(buf.m_130242_()) : null;
        if (entity == null || entity instanceof StandEntity) {
            this.stand = (StandEntity)entity;
        }
    }

    public void writeSyncPacket(FriendlyByteBuf buf, ServerPlayer recipient) {
        buf.writeBoolean(this.stand != null);
        if (this.stand != null) {
            buf.m_130130_(this.stand.m_19879_());
        }
    }

    @Override
    public int getSkin() {
        return this.skin;
    }

    @Override
    public boolean isTagged() {
        return this.tagged;
    }
}

