/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.player;

import lombok.NonNull;
import net.arna.jcraft.api.component.player.CommonSpecComponent;
import net.arna.jcraft.api.registry.JAdvancementTriggerRegistry;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.api.spec.SpecTypeUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public abstract class CommonSpecComponentImpl
implements CommonSpecComponent {
    protected final LivingEntity user;
    private SpecType type = (SpecType)JSpecTypeRegistry.NONE.get();
    private JSpec<?, ?> spec;

    public CommonSpecComponentImpl(LivingEntity livingEntity) {
        this.user = livingEntity;
    }

    @Override
    public SpecType getType() {
        return this.type;
    }

    @Override
    public void setType(SpecType type) {
        this.setTypeRaw(type);
        this.sync((Entity)this.user);
    }

    private void setTypeRaw(SpecType type) {
        LivingEntity livingEntity;
        this.type = type;
        JSpec<?, ?> jSpec = this.spec = type == null ? null : type.createSpec(this.user);
        if (!SpecTypeUtil.isNone(type) && (livingEntity = this.user) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            JAdvancementTriggerRegistry.OBTAINED_SPEC.trigger(player, type);
        }
    }

    @Override
    @Nullable
    public JSpec<?, ?> getSpec() {
        return this.spec;
    }

    public void sync(Entity entity) {
    }

    @Override
    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        SpecType type = SpecTypeUtil.readFromNBT(tag, "Type");
        if (type != null) {
            this.setTypeRaw(type);
        }
    }

    @Override
    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (this.type != null) {
            tag.m_128359_("Type", this.type.getId().toString());
        }
    }

    public boolean shouldSyncWith(ServerPlayer player) {
        return player == this.user;
    }
}

