/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.world;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.arna.jcraft.api.component.world.CommonShockwaveHandlerComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CommonShockwaveHandlerComponentImpl
implements CommonShockwaveHandlerComponent {
    private final List<CommonShockwaveHandlerComponent.Shockwave> shockwaves = new ArrayList<CommonShockwaveHandlerComponent.Shockwave>();
    protected final Level world;

    public CommonShockwaveHandlerComponentImpl(Level world) {
        this.world = world;
    }

    @Override
    public void addShockwave(double x, double y, double z, float pitch, float yaw, float scale, CommonShockwaveHandlerComponent.Shockwave.Type type) {
        CommonShockwaveHandlerComponent.Shockwave shockwave = new CommonShockwaveHandlerComponent.Shockwave(x, y, z, pitch, yaw, scale, type);
        this.shockwaves.add(shockwave);
        this.sync(shockwave);
    }

    public void sync(CommonShockwaveHandlerComponent.Shockwave shockwave) {
    }

    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        for (Tag element : tag.m_128437_("shockwaves", 10)) {
            CompoundTag compound = (CompoundTag)element;
            this.shockwaves.add(new CommonShockwaveHandlerComponent.Shockwave(compound.m_128459_("x"), compound.m_128459_("y"), compound.m_128459_("z"), compound.m_128457_("pitch"), compound.m_128457_("yaw"), compound.m_128457_("scale"), compound.m_128451_("age"), CommonShockwaveHandlerComponent.Shockwave.Type.of(compound.m_128451_("type"))));
        }
    }

    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        ListTag list = new ListTag();
        for (CommonShockwaveHandlerComponent.Shockwave shockwave : this.shockwaves) {
            CompoundTag compound = new CompoundTag();
            compound.m_128347_("x", shockwave.getX());
            compound.m_128347_("y", shockwave.getY());
            compound.m_128347_("z", shockwave.getZ());
            compound.m_128350_("pitch", shockwave.getPitch());
            compound.m_128350_("yaw", shockwave.getYaw());
            compound.m_128350_("scale", shockwave.getScale());
            compound.m_128405_("age", shockwave.getAge());
            compound.m_128405_("type", shockwave.getType().getId());
            list.add((Object)compound);
        }
        tag.m_128365_("shockwaves", (Tag)list);
    }

    public void writeSyncPacket(FriendlyByteBuf buf, ServerPlayer recipient) {
        this.writeSyncPacket(buf, (CommonShockwaveHandlerComponent.Shockwave)null);
    }

    public void writeSyncPacket(FriendlyByteBuf buf, @Nullable CommonShockwaveHandlerComponent.Shockwave shockwave) {
        List<CommonShockwaveHandlerComponent.Shockwave> shockwaves = shockwave == null ? this.shockwaves : List.of(shockwave);
        buf.writeInt(shockwaves.size());
        for (CommonShockwaveHandlerComponent.Shockwave sw : shockwaves) {
            buf.writeDouble(sw.getX());
            buf.writeDouble(sw.getY());
            buf.writeDouble(sw.getZ());
            buf.writeFloat(sw.getPitch());
            buf.writeFloat(sw.getYaw());
            buf.writeFloat(sw.getScale());
            buf.writeInt(sw.getAge());
            buf.writeInt(sw.getType().getId());
        }
    }

    public void applySyncPacket(FriendlyByteBuf buf) {
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.shockwaves.add(new CommonShockwaveHandlerComponent.Shockwave(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), CommonShockwaveHandlerComponent.Shockwave.Type.of(buf.readInt())));
        }
    }

    public void tick() {
        for (int i = 0; i < this.shockwaves.size(); ++i) {
            CommonShockwaveHandlerComponent.Shockwave shockwave = this.shockwaves.get(i);
            shockwave.tick();
            if (shockwave.getAge() < 6) continue;
            this.shockwaves.remove(i);
            --i;
        }
    }

    @Override
    public List<CommonShockwaveHandlerComponent.Shockwave> getShockwaves() {
        return this.shockwaves;
    }
}

