/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.component.impl.world;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import lombok.NonNull;
import net.arna.jcraft.api.component.world.CommonTexasHoldEmComponent;
import net.arna.jcraft.common.minigame.card.texasholdem.TexasHoldEm;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class CommonTexasHoldEmComponentImpl
implements CommonTexasHoldEmComponent {
    protected final Level world;
    protected Collection<TexasHoldEm> games = new HashSet<TexasHoldEm>();

    public CommonTexasHoldEmComponentImpl(Level world) {
        this.world = Objects.requireNonNull(world);
    }

    public void readFromNbt(CompoundTag tag) {
        for (Tag gameTag : tag.m_128437_("texas_hold_em", 10)) {
            TexasHoldEm game = new TexasHoldEm();
            game.readFromNbt((CompoundTag)gameTag);
            this.addGame(game);
        }
    }

    public void writeToNbt(CompoundTag tag) {
        ListTag gamesTag = new ListTag();
        for (TexasHoldEm game : this.games) {
            CompoundTag gameTag = new CompoundTag();
            game.writeToNbt(gameTag);
            gamesTag.add((Object)gameTag);
        }
        tag.m_128365_("texas_hold_em", (Tag)gamesTag);
    }

    @Override
    public Collection<TexasHoldEm> getGames() {
        return this.games;
    }

    @Override
    public boolean addGame(@NonNull TexasHoldEm game) {
        if (game == null) {
            throw new NullPointerException("game is marked non-null but is null");
        }
        if (this.games.contains(game)) {
            return false;
        }
        for (TexasHoldEm otherGame : this.games) {
            for (String entityUuid : otherGame.getPlayersUuid()) {
                if (!game.getPlayersUuid().contains(entityUuid)) continue;
                return false;
            }
        }
        return this.games.add(game);
    }
}

