/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.arna.jcraft.common.config.ConfigOption;
import net.minecraft.network.FriendlyByteBuf;

public class BooleanOption
extends ConfigOption {
    private boolean value;
    private final boolean defaultValue;

    protected BooleanOption(String key, String category, boolean value) {
        super(ConfigOption.Type.BOOLEAN, key, category);
        this.value = this.defaultValue = value;
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.value);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value = buf.readBoolean();
    }

    @Override
    public JsonElement write() {
        return new JsonPrimitive(Boolean.valueOf(this.value));
    }

    @Override
    public void read(JsonElement element) {
        this.value = element.getAsBoolean();
    }

    public void setValue(boolean value) {
        this.value = value;
    }
}

