/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigOption {
    private static final Map<String, ConfigOption> options = new LinkedHashMap<String, ConfigOption>();
    private static final AtomicReference<Object> immutableOptions = new AtomicReference();
    private final Type type;
    private final String key;
    private final String category;

    protected ConfigOption(Type type, String key, String category) {
        this.type = type;
        this.key = key;
        this.category = category;
        if (options.containsKey(key)) {
            throw new IllegalArgumentException("Option with the given key already exists: " + key);
        }
        options.put(key, this);
    }

    @Nullable
    public static ConfigOption getOption(String key, Type type) {
        ConfigOption option = ConfigOption.getImmutableOptions().get(key);
        if (option == null || option.getType() != type) {
            return null;
        }
        return option;
    }

    @NonNull
    public static FriendlyByteBuf writeOptions(@NonNull FriendlyByteBuf buf, Collection<ConfigOption> options) {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        for (ConfigOption option : options) {
            buf.m_130070_(option.getKey());
            option.write(buf);
        }
        return buf;
    }

    @NonNull
    public static Set<ConfigOption> readOptions(FriendlyByteBuf buf) {
        HashSet<ConfigOption> changedOptions = new HashSet<ConfigOption>();
        while (buf.readableBytes() > 0) {
            String key = buf.m_130277_();
            ConfigOption option = ConfigOption.getImmutableOptions().get(key);
            if (option == null) {
                JCraft.LOGGER.warn("Could not find option {}. Rest of the data ({} bytes) will be ignored.", (Object)key, (Object)buf.readableBytes());
                buf.readerIndex(buf.readerIndex() + buf.readableBytes());
                break;
            }
            option.read(buf);
            changedOptions.add(option);
        }
        return changedOptions;
    }

    public abstract void write(FriendlyByteBuf var1);

    public abstract void read(FriendlyByteBuf var1);

    public abstract JsonElement write();

    public abstract void read(JsonElement var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ConfigOption> getImmutableOptions() {
        Object $value = immutableOptions.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = immutableOptions;
            synchronized (atomicReference) {
                $value = immutableOptions.get();
                if ($value == null) {
                    ImmutableMap actualValue = ImmutableMap.copyOf(options);
                    $value = actualValue == null ? immutableOptions : actualValue;
                    immutableOptions.set($value);
                }
            }
        }
        return (Map)($value == immutableOptions ? null : $value);
    }

    public Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getCategory() {
        return this.category;
    }

    public static enum Type {
        INTEGER,
        FLOAT,
        BOOLEAN,
        ENUM;

    }
}

