/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import net.arna.jcraft.common.config.ConfigOption;
import net.minecraft.network.FriendlyByteBuf;

public class EnumOption<E extends Enum<?>>
extends ConfigOption {
    private final Class<E> clazz;
    private E value;
    private final E defaultValue;

    public EnumOption(String key, String category, Class<E> clazz, E value) {
        super(ConfigOption.Type.ENUM, key, category);
        this.clazz = clazz;
        this.defaultValue = value;
        this.value = this.defaultValue;
    }

    public void setValue(int ordinal) {
        this.setValue(((Enum[])this.clazz.getEnumConstants())[ordinal]);
    }

    public void setValue(E value) {
        this.value = value;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(((Enum)this.value).ordinal());
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.setValue(buf.m_130242_());
    }

    @Override
    public JsonElement write() {
        return new JsonPrimitive(((Enum)this.value).name());
    }

    @Override
    public void read(JsonElement element) {
        String name = element.getAsString();
        this.value = Arrays.stream((Enum[])this.clazz.getEnumConstants()).filter(e -> e.name().equals(name)).findFirst().orElseThrow();
    }

    public Class<E> getClazz() {
        return this.clazz;
    }

    public E getValue() {
        return this.value;
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }
}

