/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.arna.jcraft.common.config.ConfigOption;
import net.minecraft.network.FriendlyByteBuf;

public class FloatOption
extends ConfigOption {
    private float value;
    private final float defaultValue;
    private Float min;
    private Float max;

    public FloatOption(String key, String category, float value) {
        super(ConfigOption.Type.FLOAT, key, category);
        this.value = this.defaultValue = value;
    }

    public FloatOption(String key, String category, float value, float min) {
        super(ConfigOption.Type.FLOAT, key, category);
        this.value = this.defaultValue = value;
        this.min = Float.valueOf(min);
    }

    public FloatOption(String key, String category, float value, float min, float max) {
        super(ConfigOption.Type.FLOAT, key, category);
        this.value = this.defaultValue = value;
        this.min = Float.valueOf(min);
        this.max = Float.valueOf(max);
    }

    public void setValue(float value) {
        if (this.min != null && value < this.min.floatValue()) {
            value = this.min.floatValue();
        }
        if (this.max != null && value > this.max.floatValue()) {
            value = this.max.floatValue();
        }
        this.value = value;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.value);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value = buf.readFloat();
    }

    @Override
    public JsonElement write() {
        return new JsonPrimitive((Number)Float.valueOf(this.value));
    }

    @Override
    public void read(JsonElement element) {
        this.value = element.getAsFloat();
    }

    public float getValue() {
        return this.value;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public Float getMin() {
        return this.min;
    }

    public Float getMax() {
        return this.max;
    }
}

