/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.arna.jcraft.common.config.ConfigOption;
import net.minecraft.network.FriendlyByteBuf;

public class IntOption
extends ConfigOption {
    private int value;
    private final int defaultValue;
    private Integer min;
    private Integer max;

    public IntOption(String key, String category, int value) {
        super(ConfigOption.Type.INTEGER, key, category);
        this.value = this.defaultValue = value;
    }

    public IntOption(String key, String category, int value, int min) {
        super(ConfigOption.Type.INTEGER, key, category);
        this.value = this.defaultValue = value;
        this.min = min;
    }

    public IntOption(String key, String category, int value, int min, int max) {
        super(ConfigOption.Type.INTEGER, key, category);
        this.value = this.defaultValue = value;
        this.min = min;
        this.max = max;
    }

    public void setValue(int value) {
        if (this.min != null && value < this.min) {
            value = this.min;
        }
        if (this.max != null && value > this.max) {
            value = this.max;
        }
        this.value = value;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.value);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value = buf.m_130242_();
    }

    @Override
    public JsonElement write() {
        return new JsonPrimitive((Number)this.value);
    }

    @Override
    public void read(JsonElement element) {
        this.value = element.getAsInt();
    }

    public int getValue() {
        return this.value;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }
}

