/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.common.config.BooleanOption;
import net.arna.jcraft.common.config.ConfigOption;
import net.arna.jcraft.common.config.DamageScalingType;
import net.arna.jcraft.common.config.EnumOption;
import net.arna.jcraft.common.config.FloatOption;
import net.arna.jcraft.common.config.IntOption;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

public class JServerConfig {
    private static final Object $LOCK = new Object[0];
    public static final Codec<IntOption> INT_OPTION_CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(s -> (IntOption)ConfigOption.getOption(s, ConfigOption.Type.INTEGER), () -> "Unknown option: "), ConfigOption::getKey);
    public static final Codec<FloatOption> FLOAT_OPTION_CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(s -> (FloatOption)ConfigOption.getOption(s, ConfigOption.Type.FLOAT), () -> "Unknown option: "), ConfigOption::getKey);
    public static final Codec<BooleanOption> BOOLEAN_OPTION_CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(s -> (BooleanOption)ConfigOption.getOption(s, ConfigOption.Type.BOOLEAN), () -> "Unknown option: "), ConfigOption::getKey);
    public static final Codec<EnumOption<?>> ENUM_OPTION_CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(s -> (EnumOption)ConfigOption.getOption(s, ConfigOption.Type.ENUM), () -> "Unknown option: "), ConfigOption::getKey);
    private static final String BALANCE = "balance";
    public static final IntOption SPTW_TIME_STOP_DURATION = new IntOption("sptwTimeStopDuration", "balance", 35, 0);
    public static final IntOption TW_TIME_STOP_DURATION = new IntOption("twTimeStopDuration", "balance", 80, 0);
    public static final IntOption STW_TIME_STOP_DURATION = new IntOption("stwTimeStopDuration", "balance", 50, 0);
    public static final IntOption TWOH_TIME_STOP_DURATION = new IntOption("twohTimeStopDuration", "balance", 100, 0);
    public static final IntOption MIH_TIME_ACCELERATION_DURATION = new IntOption("mihTimeAccelerationDuration", "balance", 300, 0);
    public static final BooleanOption KILL_VAMPIRISM = new BooleanOption("killVampirism", "balance", false);
    public static final EnumOption<DamageScalingType> DAMAGE_SCALING_TYPE = new EnumOption<DamageScalingType>("damageScalingType", "balance", DamageScalingType.class, DamageScalingType.TargetHealth);
    public static final FloatOption DAMAGE_SCALING_MULTIPLIER = new FloatOption("damageScalingMultiplier", "balance", 0.5f);
    public static final FloatOption VS_STANDLESS_DAMAGE_MULTIPLIER = new FloatOption("vsStandlessDamageMultiplier", "balance", 1.5f);
    public static final FloatOption DAMAGE_SCALING_MINIMUM = new FloatOption("damageScalingMinimum", "balance", 0.4f);
    public static final FloatOption SCALING_PENALTY_PER_HIT = new FloatOption("scalingPenaltyPerHit", "balance", 0.02f);
    public static final BooleanOption ENABLE_MOVE_COOLDOWNS = new BooleanOption("enableMoveCooldowns", "balance", true);
    public static final FloatOption COOLDOWN_MULTIPLIER = new FloatOption("cooldownMultiplier", "balance", 1.0f);
    public static final BooleanOption SURVIVAL_CDC = new BooleanOption("survivalCDC", "balance", false);
    public static final BooleanOption ENABLE_FRIENDLY_FIRE = new BooleanOption("enableFriendlyFire", "balance", true);
    public static final IntOption BASE_AI_LEVEL = new IntOption("baseAILevel", "balance", 15, 0, 20);
    private static final String MINECRAFT_REBALANCE = "minecraft_rebalance";
    public static final BooleanOption REDUCE_DEADLY_EXPLOSIONS = new BooleanOption("reduceDeadlyExplosions", "minecraft_rebalance", true);
    public static final BooleanOption DISABLE_COMBAT_ELYTRA = new BooleanOption("disableCombatElytra", "minecraft_rebalance", true);
    private static final String INTERACTION = "interaction";
    public static final BooleanOption MINING_BARRAGE = new BooleanOption("miningBarrage", "interaction", true);
    public static final FloatOption METEOR_SPAWN_RATE = new FloatOption("meteorSpawnRate", "interaction", 0.02f, 0.0f, 1.0f);
    public static final IntOption DUMMY_DAMAGE_INDICATOR_RANGE = new IntOption("dummyDamageIndicatorRange", "interaction", 64, 0, 512);
    public static final BooleanOption CREAM_ITEM_ERASE = new BooleanOption("creamItemErase", "interaction", true);
    private static final String GAMEPLAY = "gameplay";
    public static final BooleanOption EXCLUSIVE_STANDS = new BooleanOption("exclusiveStands", "gameplay", false);
    public static final BooleanOption STAND_USER_SIGHT = new BooleanOption("standUserSight", "gameplay", false);
    public static final BooleanOption SPAWNER_STANDS = new BooleanOption("spawnerStands", "gameplay", true);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static final Path GLOBAL_DEFAULT = Path.of("./config/jconfig.json", new String[0]);

    public static void init() {
    }

    public static void load(MinecraftServer server) {
        Path path = JServerConfig.getPath(server);
        if (!Files.exists(path, new LinkOption[0])) {
            Path defaultPath = GLOBAL_DEFAULT;
            if (Files.exists(defaultPath, new LinkOption[0])) {
                Files.copy(defaultPath, path, StandardCopyOption.REPLACE_EXISTING);
            } else {
                JServerConfig.save(server);
                return;
            }
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject data = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            for (String key : data.keySet()) {
                ConfigOption option = ConfigOption.getImmutableOptions().get(key);
                if (option == null) continue;
                option.read(data.get(key));
            }
        }
        catch (IOException e) {
            JCraft.LOGGER.error("An error occurred trying to read the server config.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(MinecraftServer server) {
        Object object = $LOCK;
        synchronized (object) {
            Path path = JServerConfig.getPath(server);
            JsonObject data = new JsonObject();
            ConfigOption.getImmutableOptions().forEach((key, option) -> data.add(key, option.write()));
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                gson.toJson((JsonElement)data, (Appendable)writer);
                writer.flush();
            }
        }
    }

    @NotNull
    private static Path getPath(MinecraftServer server) throws IOException {
        Path path = server.m_129843_(LevelResource.f_78182_).resolve("jcraft.json");
        if (server.m_6982_()) {
            Path newPath = GLOBAL_DEFAULT;
            if (Files.exists(path, new LinkOption[0])) {
                JCraft.LOGGER.warn("Moving jcraft.json to config directory.");
                Files.move(path, newPath, StandardCopyOption.REPLACE_EXISTING);
            }
            path = newPath;
        }
        return path;
    }
}

