/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.data;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.registry.registries.Registrar;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.spec.SpecData;
import net.arna.jcraft.api.stand.StandData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class AttackerDataLoader {
    private static final Map<ResourceLocation, StandData> STAND_DATA = new HashMap<ResourceLocation, StandData>();
    private static final Map<ResourceLocation, SpecData> SPEC_DATA = new HashMap<ResourceLocation, SpecData>();
    private static boolean dirty = false;

    public static StandData getStandData(ResourceLocation id) {
        return STAND_DATA.getOrDefault(id, StandData.EMPTY);
    }

    public static SpecData getSpecData(ResourceLocation id) {
        return SPEC_DATA.getOrDefault(id, SpecData.EMPTY);
    }

    public static CompletableFuture<Void> onReload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> AttackerDataLoader.loadDataFiles(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(AttackerDataLoader::loadAllData);
    }

    private static Map<String, Map<ResourceLocation, JsonObject>> loadDataFiles(ResourceManager resourceManager) {
        Map standResources = resourceManager.m_214159_("stands", rl -> rl.m_135815_().endsWith(".json"));
        Map specResources = resourceManager.m_214159_("specs", rl -> rl.m_135815_().endsWith(".json"));
        HashMap resources = new HashMap(standResources);
        resources.putAll(specResources);
        Gson gson = new Gson();
        HashMap<String, Map<ResourceLocation, JsonObject>> data = new HashMap<String, Map<ResourceLocation, JsonObject>>();
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation location = ((ResourceLocation)entry.getKey()).m_247266_(path -> path.substring(path.indexOf(47) + 1, path.length() - ".json".length()));
            String kind = ((ResourceLocation)entry.getKey()).m_135815_().split("/")[0];
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonObject obj = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    data.computeIfAbsent(kind, s -> new HashMap()).put(location, obj);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                JCraft.LOGGER.error("Failed to load data for {} {}", (Object)("stands".equals(kind) ? "stand" : "spec"), (Object)location, (Object)e);
            }
        }
        return data;
    }

    private static void loadAllData(Map<String, Map<ResourceLocation, JsonObject>> data) {
        AttackerDataLoader.loadData(data.get("stands"), StandData.CODEC, JRegistries.STAND_TYPE_REGISTRY, STAND_DATA, "stand", StandData.EMPTY);
        AttackerDataLoader.loadData(data.get("specs"), SpecData.CODEC, JRegistries.SPEC_TYPE_REGISTRY, SPEC_DATA, "spec", SpecData.EMPTY);
        dirty = true;
    }

    private static <T> void loadData(Map<ResourceLocation, JsonObject> data, Codec<T> codec, Registrar<?> registry, Map<ResourceLocation, T> map, String kind, T fallback) {
        if (data == null || data.isEmpty()) {
            return;
        }
        for (Map.Entry<ResourceLocation, JsonObject> entry : data.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonObject json = entry.getValue();
            DataResult res = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            if (res.result().isEmpty()) {
                JCraft.LOGGER.error("Failed to parse {} data for {} {}: {}", (Object)kind, (Object)kind, (Object)id, res.error().map(DataResult.PartialResult::message).orElse(null));
                continue;
            }
            map.put(id, res.result().get());
        }
        for (ResourceLocation id : registry.getIds()) {
            if (id.equals((Object)JCraft.id("none")) || map.containsKey(id)) continue;
            JCraft.LOGGER.warn("No {} data found for {} type {}. Using default data.", (Object)kind, (Object)kind, (Object)id);
            map.put(id, fallback);
        }
    }

    public static void writeToBuffer(FriendlyByteBuf buf) {
        List<Map.Entry> standData = STAND_DATA.entrySet().stream().map(entry -> Map.entry((ResourceLocation)entry.getKey(), StandData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((StandData)entry.getValue())))).peek(e -> {
            if (((DataResult)e.getValue()).error().isPresent()) {
                JCraft.LOGGER.error("Failed to encode StandData for {}: {}", e.getKey(), (Object)((DataResult.PartialResult)((DataResult)e.getValue()).error().get()).message());
            }
        }).filter(e -> ((DataResult)e.getValue()).result().isPresent()).map(e -> Map.entry((ResourceLocation)e.getKey(), (CompoundTag)((DataResult)e.getValue()).result().get())).toList();
        List<Map.Entry> specData = SPEC_DATA.entrySet().stream().map(entry -> Map.entry((ResourceLocation)entry.getKey(), SpecData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((SpecData)entry.getValue())))).peek(e -> {
            if (((DataResult)e.getValue()).error().isPresent()) {
                JCraft.LOGGER.error("Failed to encode SpecData for {}: {}", e.getKey(), (Object)((DataResult.PartialResult)((DataResult)e.getValue()).error().get()).message());
            }
        }).filter(e -> ((DataResult)e.getValue()).result().isPresent()).map(e -> Map.entry((ResourceLocation)e.getKey(), (CompoundTag)((DataResult)e.getValue()).result().get())).toList();
        buf.m_130130_(standData.size());
        for (Map.Entry entry2 : standData) {
            buf.m_130085_((ResourceLocation)entry2.getKey());
            buf.m_130079_((CompoundTag)entry2.getValue());
        }
        buf.m_130130_(specData.size());
        for (Map.Entry entry2 : specData) {
            buf.m_130085_((ResourceLocation)entry2.getKey());
            buf.m_130079_((CompoundTag)entry2.getValue());
        }
    }

    public static void readFromBuffer(FriendlyByteBuf buf) {
        int standDataSize = buf.m_130242_();
        for (int i = 0; i < standDataSize; ++i) {
            ResourceLocation id = buf.m_130281_();
            CompoundTag data = buf.m_130260_();
            DataResult result = StandData.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)data);
            if (result.error().isPresent()) {
                JCraft.LOGGER.error("Failed to decode StandData for {}: {}", (Object)id, (Object)((DataResult.PartialResult)result.error().get()).message());
                continue;
            }
            STAND_DATA.put(id, (StandData)result.result().get());
        }
        int specDataSize = buf.m_130242_();
        for (int i = 0; i < specDataSize; ++i) {
            ResourceLocation id = buf.m_130281_();
            CompoundTag data = buf.m_130260_();
            DataResult result = SpecData.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)data);
            if (result.error().isPresent()) {
                JCraft.LOGGER.error("Failed to decode SpecData for {}: {}", (Object)id, (Object)((DataResult.PartialResult)result.error().get()).message());
                continue;
            }
            SPEC_DATA.put(id, (SpecData)result.result().get());
        }
    }

    public static boolean isDirty() {
        return dirty;
    }

    public static void setDirty(boolean dirty) {
        AttackerDataLoader.dirty = dirty;
    }
}

