/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.data;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class MoveSetLoader {
    private static final Map<ResourceLocation, Map<String, Collection<Pair<ResourceLocation, JsonObject>>>> PENDING_MOVE_SET_DATA = new HashMap<ResourceLocation, Map<String, Collection<Pair<ResourceLocation, JsonObject>>>>();

    public static void attemptLoad(MoveSet<?, ?> moveSet) {
        ResourceLocation typeLoc = moveSet.getType().getId();
        String moveSetName = moveSet.getName();
        if (PENDING_MOVE_SET_DATA.getOrDefault(typeLoc, Collections.emptyMap()).containsKey(moveSetName)) {
            Map<String, Collection<Pair<ResourceLocation, JsonObject>>> typeMoveSets = PENDING_MOVE_SET_DATA.get(typeLoc);
            moveSet.load(JsonOps.INSTANCE, typeMoveSets.get(moveSetName), (Executor)null);
            typeMoveSets.remove(moveSetName);
            if (typeMoveSets.isEmpty()) {
                PENDING_MOVE_SET_DATA.remove(typeLoc);
            }
        }
    }

    public static CompletableFuture<Void> onReload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> MoveSetLoader.loadFiles(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(data -> MoveSetLoader.loadMoveSets(data, gameExecutor));
    }

    private static Map<ResourceLocation, Multimap<String, Pair<ResourceLocation, JsonObject>>> loadFiles(ResourceManager resourceManager) {
        Map resources = resourceManager.m_214159_("movesets", rl -> rl.m_135815_().split("/").length >= 4 && rl.m_135815_().endsWith(".json"));
        Gson gson = new Gson();
        HashMap<ResourceLocation, Multimap<String, Pair<ResourceLocation, JsonObject>>> moveSets = new HashMap<ResourceLocation, Multimap<String, Pair<ResourceLocation, JsonObject>>>();
        for (Map.Entry entry : resources.entrySet()) {
            String[] parts = ((ResourceLocation)entry.getKey()).m_135815_().split("/");
            ResourceLocation typeLoc = ((ResourceLocation)entry.getKey()).m_247449_(parts[2]);
            String moveSetName = parts[3];
            Multimap map = moveSets.computeIfAbsent(typeLoc, s -> MultimapBuilder.hashKeys((int)2).arrayListValues().build());
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonObject obj = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    map.put((Object)moveSetName, (Object)Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)obj));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                JCraft.LOGGER.error("Failed to load move {} for move set {} of type {}", entry.getKey(), (Object)moveSetName, (Object)typeLoc, (Object)e);
            }
        }
        return moveSets;
    }

    private static void loadMoveSets(Map<ResourceLocation, Multimap<String, Pair<ResourceLocation, JsonObject>>> moveSets, Executor gameExecutor) {
        PENDING_MOVE_SET_DATA.clear();
        for (Map.Entry<ResourceLocation, Multimap<String, Pair<ResourceLocation, JsonObject>>> typeEntry : moveSets.entrySet()) {
            ResourceLocation typeLoc = typeEntry.getKey();
            Multimap<String, Pair<ResourceLocation, JsonObject>> sets = typeEntry.getValue();
            for (Map.Entry moveSetEntry : sets.asMap().entrySet()) {
                String moveSetName = (String)moveSetEntry.getKey();
                MoveSet moveSet = MoveSetManager.get(typeLoc, moveSetName);
                if (moveSet == null) {
                    PENDING_MOVE_SET_DATA.computeIfAbsent(typeLoc, k -> new HashMap()).put(moveSetName, (Collection)moveSetEntry.getValue());
                    continue;
                }
                moveSet.load(JsonOps.INSTANCE, (Collection)moveSetEntry.getValue(), gameExecutor);
            }
        }
    }
}

