/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.effects;

import java.util.Random;
import net.arna.jcraft.api.component.living.CommonMiscComponent;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WeightlessStatusEffect
extends MobEffect {
    private static final Random random = new Random();

    public WeightlessStatusEffect() {
        super(MobEffectCategory.NEUTRAL, 17);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return amplifier == 1;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level world = entity.m_9236_();
        Vec3 pos = entity.m_20182_();
        Vec3 downPos = pos.m_82549_(RotationUtil.vecPlayerToWorld(0.0, -5.0, 0.0, GravityChangerAPI.getGravityDirection((Entity)entity)));
        if (entity.m_9236_().f_46443_) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123789_, pos.f_82479_ + random.nextDouble() - 0.5, pos.f_82480_ + random.nextDouble() - 0.5, pos.f_82481_ + random.nextDouble() - 0.5, 0.0, 0.0, 0.0);
        } else {
            CommonMiscComponent misc = JComponentPlatformUtils.getMiscData(entity);
            if (!entity.m_6084_()) {
                entity.m_21195_((MobEffect)this);
                return;
            }
            BlockHitResult hitResult = world.m_45547_(new ClipContext(pos, downPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                misc.setHoverTime(0);
            } else {
                int newHoverTime = misc.getHoverTime() + 1;
                misc.setHoverTime(newHoverTime);
                if (newHoverTime > 10) {
                    entity.m_21195_((MobEffect)this);
                }
            }
        }
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        super.m_6385_(entity, attributes, amplifier);
        if (entity.m_9236_().f_46443_) {
            return;
        }
        CommonMiscComponent misc = JComponentPlatformUtils.getMiscData(entity);
        misc.setPrevNoGrav(entity.m_20068_());
        misc.setHoverTime(0);
        if (entity.m_21224_()) {
            return;
        }
        Direction lookDir = JUtils.getLookDirection((Entity)entity);
        if (amplifier == 1) {
            if (lookDir != GravityChangerAPI.getGravityDirection((Entity)entity)) {
                GravityChangerAPI.addGravity((Entity)entity, new Gravity(lookDir, 1, 200, "effect"));
            }
        } else {
            entity.m_20242_(true);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        super.m_6386_(entity, attributes, amplifier);
        if (entity.m_9236_().f_46443_) {
            return;
        }
        GravityChangerAPI.clearGravity((Entity)entity);
        if (!JComponentPlatformUtils.getMiscData(entity).getPrevNoGrav()) {
            entity.m_20242_(false);
        }
    }
}

