/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity;

import java.util.Arrays;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.common.util.IOwnable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GEButterflyEntity
extends FlyingMob
implements GeoEntity,
IOwnable {
    private boolean hasMaster = false;
    private LivingEntity master;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public GEButterflyEntity(EntityType<? extends FlyingMob> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.f_21344_ = new FlyingPathNavigation((Mob)this, world);
        Arrays.fill(this.f_21347_, 2.0f);
    }

    @Override
    public LivingEntity getMaster() {
        return this.master;
    }

    @Override
    public void setMaster(LivingEntity m) {
        this.master = m;
        this.hasMaster = true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public InteractionResult m_7111_(Player player, Vec3 hitPos, InteractionHand hand) {
        if (player == this.master) {
            if (!player.m_21120_(hand).m_41619_()) {
                return InteractionResult.FAIL;
            }
            player.m_21008_(hand, this.m_21205_());
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ || !this.hasMaster) {
            return;
        }
        if (this.master == null) {
            this.m_6074_();
            return;
        }
        if (this.m_20280_((Entity)this.master) > 16.0) {
            this.f_21344_.m_5624_((Entity)this.master, 1.0);
        } else if (this.f_21344_.m_26572_()) {
            this.f_21344_.m_26573_();
        }
    }

    public static AttributeSupplier.Builder createButterflyAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22276_, 10.0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("HasMaster", this.hasMaster);
        LivingEntity livingEntity = this.master;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            nbt.m_128362_("MasterUUID", player.m_20148_());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.hasMaster = nbt.m_128471_("HasMaster");
        if (nbt.m_128403_("MasterUUID")) {
            this.setMaster((LivingEntity)this.m_9236_().m_46003_(nbt.m_128342_("MasterUUID")));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GEButterflyEntity> state) {
        if (this.m_6084_()) {
            state.setAnimation(RawAnimation.begin().thenLoop("animation.gebutterfly.idle"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

