/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.common.util.IOwnable;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GERScorpionEntity
extends Mob
implements GeoEntity,
IOwnable {
    private static final EntityDataAccessor<Optional<UUID>> OWNERUUID = SynchedEntityData.m_135353_(GERScorpionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> ISROCK = SynchedEntityData.m_135353_(GERScorpionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(GERScorpionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Vec3 initialVel;
    private LivingEntity jumpTarget;
    private LivingEntity owner;
    private int landedTimer;
    private int rockStun = 15;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public GERScorpionEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
        this.m_147244_(true);
    }

    public void setInitialVel(Vec3 initV) {
        this.m_20256_(initV);
        this.initialVel = initV;
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.f_19804_.m_135370_(OWNERUUID);
    }

    public void setOwnerUUID(UUID uuid) {
        this.f_19804_.m_135381_(OWNERUUID, Optional.of(uuid));
    }

    public boolean isRock() {
        return (Boolean)this.f_19804_.m_135370_(ISROCK);
    }

    public void setRock(boolean r) {
        this.f_19804_.m_135381_(ISROCK, (Object)r);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(CHARGED);
    }

    public void charge() {
        this.f_19804_.m_135381_(CHARGED, (Object)true);
        this.rockStun = 21;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNERUUID, Optional.empty());
        this.f_19804_.m_135372_(ISROCK, (Object)true);
        this.f_19804_.m_135372_(CHARGED, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        Optional<UUID> ownerID = this.getOwnerUUID();
        ownerID.ifPresent(id -> nbt.m_128362_("OwnerUUID", id));
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("OwnerUUID")) {
            this.setOwnerUUID(nbt.m_128342_("OwnerUUID"));
        }
    }

    @Override
    public LivingEntity getMaster() {
        return this.owner;
    }

    @Override
    public void setMaster(LivingEntity entity) {
        this.owner = entity;
        this.setOwnerUUID(this.owner.m_20148_());
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_7337_(Entity other) {
        return false;
    }

    public boolean m_20068_() {
        if (this.isRock()) {
            return true;
        }
        return super.m_20068_();
    }

    private void Transform() {
        this.m_20256_(Vec3.f_82478_);
        this.f_19864_ = true;
        this.m_147244_(false);
        this.setRock(false);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 curPos = this.m_20182_();
        if (this.m_9236_().f_46443_) {
            if (!this.isRock()) {
                ++this.landedTimer;
            }
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            if (this.landedTimer < 1) {
                Vec3 towardsVec = JUtils.deltaPos((Entity)this);
                for (double i = 0.0; i < 6.0; i += 1.0) {
                    double lerp = i / 6.0;
                    this.m_9236_().m_7106_((ParticleOptions)(this.isCharged() ? ParticleTypes.f_123771_ : ParticleTypes.f_123749_), x + towardsVec.f_82479_ * lerp, y + towardsVec.f_82480_ * lerp, z + towardsVec.f_82481_ * lerp, towardsVec.f_82479_, towardsVec.f_82480_, towardsVec.f_82481_);
                }
            } else if (this.landedTimer == 1) {
                for (int i = 0; i < 8; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), x + (double)this.f_19796_.m_188501_() - 0.5, y + (double)this.f_19796_.m_188501_() - 0.5, z + (double)this.f_19796_.m_188501_() - 0.5, 0.0, 0.0, 0.0);
                }
            }
        } else if (this.owner != null) {
            HashSet<Entity> filter = new HashSet<Entity>();
            filter.add((Entity)this.owner);
            filter.add((Entity)this);
            if (this.owner.m_20160_()) {
                filter.addAll(this.owner.m_20197_());
            }
            DamageSource damageSource = this.m_9236_().m_269111_().m_269333_(this.owner);
            if (this.isRock()) {
                if (!this.m_20184_().equals((Object)this.initialVel)) {
                    this.Transform();
                }
                Vec3 towardsVec = curPos.m_82546_(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_));
                ArrayList<LivingEntity> hurtAll = new ArrayList<LivingEntity>();
                for (double i = 0.0; i < 3.0; i += 1.0) {
                    hurtAll.addAll(JUtils.generateHitbox(this.m_9236_(), curPos.m_82549_(towardsVec.m_82490_(i / 3.0)), 0.5, filter));
                }
                hurtAll.removeIf(e -> !JUtils.canDamage(damageSource, (Entity)e));
                if (!hurtAll.isEmpty()) {
                    this.jumpTarget = (LivingEntity)hurtAll.get(0);
                    for (LivingEntity l : hurtAll) {
                        LivingEntity target = JUtils.getUserIfStand(l);
                        Attacks.damageLogic(this.m_9236_(), target, this.m_20184_(), this.rockStun, 1, false, 6.0f, true, 10, damageSource, (Entity)this.owner, CommonHitPropertyComponent.HitAnimation.MID);
                    }
                    this.Transform();
                    JCraft.createParticle((ServerLevel)this.m_9236_(), curPos.f_82479_ + this.f_19796_.m_188583_() * 0.25, curPos.f_82480_ + this.f_19796_.m_188583_() * 0.25, curPos.f_82481_ + this.f_19796_.m_188583_() * 0.25, JParticleType.HIT_SPARK_1);
                }
            } else {
                ++this.landedTimer;
                if (this.landedTimer == 15) {
                    if (this.jumpTarget != null) {
                        Vec3 eyePos = this.jumpTarget.m_20182_().m_82520_(0.0, (double)(this.jumpTarget.m_20206_() / 2.0f), 0.0);
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, eyePos);
                        this.m_20256_(this.m_20184_().m_82549_(eyePos.m_82546_(this.m_20182_()).m_82490_(0.33)));
                    } else {
                        this.m_5997_(0.0, 0.65, 0.0);
                    }
                    this.f_19864_ = true;
                }
                if (this.landedTimer == 20) {
                    Set<LivingEntity> hurt = JUtils.generateHitbox(this.m_9236_(), this.m_20182_(), 1.5, filter);
                    if (this.isCharged()) {
                        for (LivingEntity l : hurt) {
                            LivingEntity target = JUtils.getUserIfStand(l);
                            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 0, false, true));
                            Attacks.damageLogic(this.m_9236_(), target, Vec3.f_82478_, 15, 1, false, 3.0f, true, 7, damageSource, (Entity)this.owner, CommonHitPropertyComponent.HitAnimation.MID);
                        }
                    } else {
                        for (LivingEntity l : hurt) {
                            LivingEntity target = JUtils.getUserIfStand(l);
                            Attacks.damageLogic(this.m_9236_(), target, Vec3.f_82478_, 15, 1, false, 3.0f, true, 7, damageSource, (Entity)this.owner, CommonHitPropertyComponent.HitAnimation.MID);
                        }
                    }
                }
            }
            if (this.f_19797_ > 30) {
                this.m_6074_();
            }
        } else if (this.getOwnerUUID().isPresent()) {
            UUID searchID = this.getOwnerUUID().get();
            AABB box = AABB.m_165882_((Vec3)this.m_20182_(), (double)64.0, (double)64.0, (double)64.0);
            boolean found = false;
            for (LivingEntity e2 : this.m_9236_().m_6443_(LivingEntity.class, box, EntitySelector.f_20406_)) {
                if (!e2.m_20148_().equals(searchID)) continue;
                this.setMaster(e2);
                found = true;
                break;
            }
            if (!found) {
                this.m_6074_();
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GERScorpionEntity> state) {
        if (this.isRock()) {
            state.setAnimation(RawAnimation.begin().thenLoop("animation.gerscorpion.rock"));
        } else {
            state.setAnimation(RawAnimation.begin().thenPlay("animation.gerscorpion.transform").thenPlayAndHold("animation.gerscorpion.attack"));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

