/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.ai.goal.CloneAttackGoal;
import net.arna.jcraft.common.util.IOwnable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class PlayerCloneEntity
extends Monster
implements RangedAttackMob,
IOwnable {
    private static final EntityDataAccessor<Optional<UUID>> MASTER = SynchedEntityData.m_135353_(PlayerCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> MASTER_NAME = SynchedEntityData.m_135353_(PlayerCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> SAND = SynchedEntityData.m_135353_(PlayerCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RENDER_FOR_MASTER = SynchedEntityData.m_135353_(PlayerCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> PART_MASK = SynchedEntityData.m_135353_(PlayerCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final RangedBowAttackGoal<PlayerCloneEntity> bowAttackGoal = new RangedBowAttackGoal((Monster)this, 1.0, 30, 15.0f);
    private final CloneAttackGoal cloneAttackGoal = new CloneAttackGoal(this, 1.0){

        @Override
        public void m_8041_() {
            super.m_8041_();
            PlayerCloneEntity.this.m_21561_(false);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            PlayerCloneEntity.this.m_21561_(true);
        }
    };
    private boolean allowItemExchange = true;
    private GameProfile gameProfile;
    private LivingEntity persistTarget = null;
    private LivingEntity master;
    private int cooldown;
    private int maxCooldown;
    private final PathNavigation navigation;
    private int disabledSlots;

    public PlayerCloneEntity(Level world) {
        super((EntityType)JEntityTypeRegistry.PLAYER_CLONE.get(), world);
        Arrays.fill(this.f_21348_, 2.0f);
        Arrays.fill(this.f_21347_, 2.0f);
        this.updateAttackType();
        this.navigation = this.m_21573_();
        this.cooldown = 0;
        this.maxCooldown = 10;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MASTER, Optional.empty());
        this.f_19804_.m_135372_(MASTER_NAME, (Object)"");
        this.f_19804_.m_135372_(SAND, (Object)false);
        this.f_19804_.m_135372_(RENDER_FOR_MASTER, (Object)true);
        this.f_19804_.m_135372_(PART_MASK, (Object)0);
    }

    public void disableDrops() {
        Arrays.fill(this.f_21348_, 0.0f);
        Arrays.fill(this.f_21347_, 0.0f);
    }

    public void disableItemExchange() {
        this.allowItemExchange = false;
    }

    @Override
    public LivingEntity getMaster() {
        return this.master;
    }

    public GameProfile getGameProfile() {
        if (!(this.gameProfile != null && this.gameProfile.getId() != null && this.gameProfile.getName() != null && this.gameProfile.getId().equals(this.getMasterId()) && this.gameProfile.getName().equals(this.getMasterName()) || this.getMasterId() == null)) {
            this.gameProfile = new GameProfile(this.getMasterId(), this.getMasterName());
        }
        return this.gameProfile;
    }

    @Override
    public void setMaster(LivingEntity m) {
        this.master = m;
        Component mName = m.m_7755_();
        this.m_6593_(mName);
        this.f_19804_.m_135381_(MASTER, Optional.of(m.m_20148_()));
        this.f_19804_.m_135381_(MASTER_NAME, (Object)m.m_6302_());
        if (!(m instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)m;
        byte partMask = 0;
        for (PlayerModelPart part : PlayerModelPart.values()) {
            if (!player.m_36170_(part)) continue;
            partMask = (byte)(partMask | (byte)part.m_36445_());
        }
        this.f_19804_.m_135381_(PART_MASK, (Object)partMask);
        this.m_21559_(player.m_5737_() == HumanoidArm.LEFT);
    }

    public UUID getMasterId() {
        return ((Optional)this.f_19804_.m_135370_(MASTER)).orElse(null);
    }

    @NonNull
    public String getMasterName() {
        return (String)this.f_19804_.m_135370_(MASTER_NAME);
    }

    public boolean shouldRenderForMaster() {
        return (Boolean)this.f_19804_.m_135370_(RENDER_FOR_MASTER);
    }

    public void setShouldRenderForMaster(boolean shouldRenderForMaster) {
        this.f_19804_.m_135381_(RENDER_FOR_MASTER, (Object)shouldRenderForMaster);
    }

    public boolean isSand() {
        return (Boolean)this.f_19804_.m_135370_(SAND);
    }

    public void markSand() {
        this.f_19804_.m_135381_(SAND, (Object)true);
    }

    public byte getPartMask() {
        return (Byte)this.f_19804_.m_135370_(PART_MASK);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 32.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_21531_() {
        return true;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.getMasterId() != null) {
            nbt.m_128362_("Master", this.getMasterId());
            nbt.m_128359_("MasterName", this.getMasterName());
            nbt.m_128344_("PartMask", this.getPartMask());
            this.disabledSlots = nbt.m_128451_("DisabledSlots");
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128403_("Master")) {
            this.f_19804_.m_135381_(MASTER, Optional.of(nbt.m_128342_("Master")));
            this.f_19804_.m_135381_(MASTER_NAME, (Object)nbt.m_128461_("MasterName"));
            this.f_19804_.m_135381_(PART_MASK, (Object)nbt.m_128445_("PartMask"));
            this.disabledSlots = nbt.m_128451_("DisabledSlots");
        }
        this.updateAttackType();
    }

    private EquipmentSlot getSlotFromPosition(Vec3 hitPos) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        double d = hitPos.f_82480_;
        EquipmentSlot equipmentSlot2 = EquipmentSlot.FEET;
        if (d >= 0.1 && d < 0.55 && this.m_21033_(equipmentSlot2)) {
            equipmentSlot = EquipmentSlot.FEET;
        } else if (d >= 0.9 && d < 1.6 && this.m_21033_(EquipmentSlot.CHEST)) {
            equipmentSlot = EquipmentSlot.CHEST;
        } else if (d >= 0.4 && d < 1.2 && this.m_21033_(EquipmentSlot.LEGS)) {
            equipmentSlot = EquipmentSlot.LEGS;
        } else if (d >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            equipmentSlot = EquipmentSlot.HEAD;
        } else if (!this.m_21033_(EquipmentSlot.MAINHAND) && this.m_21033_(EquipmentSlot.OFFHAND)) {
            equipmentSlot = EquipmentSlot.OFFHAND;
        }
        return equipmentSlot;
    }

    public InteractionResult m_7111_(Player player, Vec3 hitPos, InteractionHand hand) {
        if (player != this.master || !player.m_6144_() || !this.allowItemExchange) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_150930_(Items.f_42656_)) {
            if (player.m_5833_()) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
            if (itemStack.m_41619_()) {
                EquipmentSlot equipmentSlot3;
                EquipmentSlot equipmentSlot2 = this.getSlotFromPosition(hitPos);
                EquipmentSlot equipmentSlot4 = equipmentSlot3 = this.isSlotDisabled(equipmentSlot2) ? equipmentSlot : equipmentSlot2;
                if (this.m_21033_(equipmentSlot3) && this.equip(player, equipmentSlot2, itemStack, hand)) {
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (this.isSlotDisabled(equipmentSlot)) {
                    return InteractionResult.FAIL;
                }
                if (this.equip(player, equipmentSlot, itemStack, hand)) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private boolean isSlotDisabled(EquipmentSlot slot) {
        return (this.disabledSlots & 1 << slot.m_20749_()) != 0;
    }

    private boolean equip(Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack itemStack = this.m_6844_(slot);
        if (!itemStack.m_41619_() && (this.disabledSlots & 1 << slot.m_20749_() + 8) != 0) {
            return false;
        }
        if (itemStack.m_41619_() && (this.disabledSlots & 1 << slot.m_20749_() + 16) != 0) {
            return false;
        }
        if (player.m_150110_().f_35937_ && itemStack.m_41619_() && !stack.m_41619_()) {
            ItemStack itemStack2 = stack.m_41777_();
            itemStack2.m_41764_(1);
            this.m_8061_(slot, itemStack2);
            return true;
        }
        if (!stack.m_41619_() && stack.m_41613_() > 1) {
            if (!itemStack.m_41619_()) {
                return false;
            }
            ItemStack itemStack2 = stack.m_41777_();
            itemStack2.m_41764_(1);
            this.m_8061_(slot, itemStack2);
            stack.m_41774_(1);
            return true;
        }
        this.m_8061_(slot, stack);
        player.m_21008_(hand, itemStack);
        return true;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        super.m_8061_(slot, stack);
        this.updateAttackType();
        if (slot == EquipmentSlot.MAINHAND) {
            double maxCooldown = 10.0;
            Collection attackSpeedModifiers = this.m_21205_().m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_);
            for (AttributeModifier attackSpeedModifier : attackSpeedModifiers) {
                maxCooldown *= -attackSpeedModifier.m_22218_();
            }
            if (maxCooldown < 0.0) {
                maxCooldown = 0.0;
            }
            this.maxCooldown = (int)maxCooldown;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.isSand() && this.f_19797_ % 4 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49992_.m_49966_()), this.m_20185_() + this.m_217043_().m_216328_(0.0, 0.5), this.m_20187_(), this.m_20189_() + this.m_217043_().m_216328_(0.0, 0.5), 0.0, 0.0, 0.0);
            }
        } else if (this.master == null) {
            LivingEntity attacker;
            UUID master;
            if (this.f_19797_ % 40 == 0 && (master = this.getMasterId()) != null) {
                for (ServerPlayer serverPlayerEntity : ((ServerLevel)this.m_9236_()).m_6907_()) {
                    if (!serverPlayerEntity.m_20148_().equals(master)) continue;
                    this.master = serverPlayerEntity;
                }
            }
            if ((attacker = this.m_21188_()) != null) {
                this.m_6710_(attacker);
            }
        } else {
            --this.cooldown;
            if (this.persistTarget == null) {
                LivingEntity attacker;
                LivingEntity attacking = this.master.m_21214_();
                if (attacking != null && attacking.m_6084_()) {
                    this.persistTarget = attacking;
                }
                if ((attacker = this.master.m_21188_()) != null && attacker.m_6084_()) {
                    this.persistTarget = attacker;
                }
                if (this.m_20280_((Entity)this.master) > 100.0) {
                    this.navigation.m_5624_((Entity)this.master, 1.0);
                }
            } else if (this.persistTarget.m_6084_() && this.m_6779_(this.persistTarget)) {
                this.m_6710_(this.persistTarget);
            } else {
                this.persistTarget = null;
                this.m_6710_(null);
                if (!this.navigation.m_26571_()) {
                    this.navigation.m_26573_();
                }
            }
        }
    }

    public boolean m_6779_(LivingEntity target) {
        PlayerCloneEntity clone;
        return target != this.master && target != this && (!(target instanceof PlayerCloneEntity) || !(clone = (PlayerCloneEntity)target).getMasterId().equals(this.getMasterId())) && super.m_6779_(target);
    }

    public void updateAttackType() {
        if (this.m_9236_() == null || this.m_9236_().f_46443_) {
            return;
        }
        this.f_21345_.m_25363_((Goal)this.cloneAttackGoal);
        this.f_21345_.m_25363_(this.bowAttackGoal);
        ItemStack itemStack = this.m_21120_(ProjectileUtil.m_37297_((LivingEntity)this, (Item)Items.f_42411_));
        if (itemStack.m_150930_(Items.f_42411_)) {
            this.f_21345_.m_25352_(2, this.bowAttackGoal);
        } else {
            this.f_21345_.m_25352_(2, (Goal)this.cloneAttackGoal);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        ItemStack itemStack = this.m_6298_(this.m_21120_(ProjectileUtil.m_37297_((LivingEntity)this, (Item)Items.f_42411_)));
        AbstractArrow persistentProjectileEntity = this.createArrowProjectile(itemStack, pullProgress);
        double d = target.m_20185_() - this.m_20185_();
        double e = target.m_20227_(0.33) - persistentProjectileEntity.m_20186_();
        double f = target.m_20189_() - this.m_20189_();
        double g = Math.sqrt(d * d + f * f);
        persistentProjectileEntity.m_6686_(d, e + g * 0.2, f, 1.6f, 2.0f);
        this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)persistentProjectileEntity);
    }

    protected AbstractArrow createArrowProjectile(ItemStack arrow, float damageModifier) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrow, (float)damageModifier);
    }

    public static AttributeSupplier.Builder createCloneAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 16.0).m_22266_(Attributes.f_22282_).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void startCooldown() {
        this.cooldown = this.maxCooldown;
    }
}

