/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity;

import java.util.Stack;
import lombok.NonNull;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.AbstractPurpleHazeEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class PurpleHazeCloudEntity
extends Entity {
    public static int MAX_AGE = 100;
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(PurpleHazeCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> POISON_TYPE = SynchedEntityData.m_135353_(PurpleHazeCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PurpleHazeCloudEntity(Level world, float radius, AbstractPurpleHazeEntity.PoisonType poisonType) {
        this(world);
        this.setRadius(radius);
        if (poisonType != null) {
            this.f_19804_.m_135381_(POISON_TYPE, (Object)poisonType.ordinal());
        }
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
    }

    public AbstractPurpleHazeEntity.PoisonType getPoisonType() {
        return AbstractPurpleHazeEntity.PoisonType.values()[(Integer)this.f_19804_.m_135370_(POISON_TYPE)];
    }

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
    }

    public PurpleHazeCloudEntity(Level world) {
        super((EntityType)JEntityTypeRegistry.PURPLE_HAZE_CLOUD.get(), world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(POISON_TYPE, (Object)0);
    }

    protected void m_7378_(CompoundTag nbt) {
        this.f_19797_ = nbt.m_128451_("Age");
        this.setRadius(nbt.m_128457_("Radius"));
        this.f_19804_.m_135381_(POISON_TYPE, (Object)nbt.m_128451_("PoisonType"));
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Age", this.f_19797_);
        nbt.m_128350_("Radius", this.getRadius());
        nbt.m_128405_("PoisonType", ((Integer)this.f_19804_.m_135370_(POISON_TYPE)).intValue());
    }

    public void m_8119_() {
        super.m_8119_();
        float radius = this.getRadius();
        AbstractPurpleHazeEntity.PoisonType poisonType = this.getPoisonType();
        if (this.m_9236_().m_5776_()) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            int i = 0;
            while ((float)i < radius) {
                this.m_9236_().m_6493_((ParticleOptions)JParticleTypeRegistry.PURPLE_HAZE_CLOUD.get(), false, x + this.f_19796_.m_188583_() * (double)radius / 2.0, y + this.f_19796_.m_188583_() * (double)radius / 2.0, z + this.f_19796_.m_188583_() * (double)radius / 2.0, 0.0, 0.0, 0.0);
                Level level = this.m_9236_();
                level.m_6493_((ParticleOptions)(switch (poisonType) {
                    default -> throw new IncompatibleClassChangeError();
                    case AbstractPurpleHazeEntity.PoisonType.HARMING -> (SimpleParticleType)JParticleTypeRegistry.PURPLE_HAZE_PARTICLE.get();
                    case AbstractPurpleHazeEntity.PoisonType.NULLIFYING -> ParticleTypes.f_123759_;
                    case AbstractPurpleHazeEntity.PoisonType.DEBILITATING -> ParticleTypes.f_123765_;
                }), false, x + this.f_19796_.m_188583_() * (double)radius / 2.0, y + this.f_19796_.m_188583_() * (double)radius / 2.0, z + this.f_19796_.m_188583_() * (double)radius / 2.0, 0.0, 0.0, 0.0);
                ++i;
            }
        } else {
            this.setRadius(radius - 0.025f);
            if (this.getRadius() <= 0.0f || this.f_19797_ >= MAX_AGE) {
                this.m_146870_();
                return;
            }
            this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.f_20406_.and(EntitySelector.f_20402_)).forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    switch (poisonType) {
                        case HARMING: {
                            AbstractPurpleHazeEntity.infect(living, 4);
                            break;
                        }
                        case DEBILITATING: {
                            AbstractPurpleHazeEntity.infect(living, 3, MobEffects.f_19610_);
                            AbstractPurpleHazeEntity.infect(living, 3, MobEffects.f_19597_);
                            AbstractPurpleHazeEntity.infect(living, 3, MobEffects.f_19613_);
                            break;
                        }
                        case NULLIFYING: {
                            Stack<MobEffect> toRemove = new Stack<MobEffect>();
                            living.m_21220_().forEach(statusEffectInstance -> {
                                MobEffect effectType = statusEffectInstance.m_19544_();
                                if (effectType != JStatusRegistry.DAZED.get() && effectType != JStatusRegistry.KNOCKDOWN.get()) {
                                    toRemove.add(effectType);
                                }
                            });
                            toRemove.forEach(arg_0 -> ((LivingEntity)living).m_21195_(arg_0));
                        }
                    }
                }
            });
        }
    }

    public void m_7350_(@NonNull EntityDataAccessor<?> data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (RADIUS.equals(data)) {
            this.m_6210_();
        }
        super.m_7350_(data);
    }

    @NonNull
    protected AABB m_142242_() {
        float radius = this.getRadius();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        return new AABB(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius);
    }
}

