/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.ai.goal.SHAAttackGoal;
import net.arna.jcraft.common.util.IOwnable;
import net.arna.jcraft.common.util.JExplosionModifier;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SheerHeartAttackEntity
extends Mob
implements GeoEntity,
IOwnable {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_ID = SynchedEntityData.m_135353_(SheerHeartAttackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private LivingEntity master;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation SHA_WALK = RawAnimation.begin().thenLoop("animation.sha.walk");
    public static final RawAnimation SHA_IDLE = RawAnimation.begin().thenLoop("animation.sha.idle");

    public SheerHeartAttackEntity(Level world) {
        super((EntityType)JEntityTypeRegistry.SHEER_HEART_ATTACK.get(), world);
    }

    @Override
    public LivingEntity getMaster() {
        return this.master;
    }

    @Override
    public void setMaster(LivingEntity owner) {
        this.master = owner;
        this.setOwnerId(owner.m_20148_());
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_ID)).orElse(null);
    }

    private void setOwnerId(UUID id) {
        this.f_19804_.m_135381_(OWNER_ID, Optional.of(id));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_ID, Optional.empty());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SHAAttackGoal(this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 32.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(6, (Goal)new LeapAtTargetGoal((Mob)this, 0.2f));
    }

    protected void m_6475_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return;
        }
        super.m_6475_(source, amount);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128362_("Owner", this.getOwnerId());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setOwnerId(nbt.m_128342_("Owner"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.master != null && amount < 256.0f) {
            this.master.m_6469_(source, amount / 4.0f);
        }
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            JCraft.getClientEntityHandler().sheerHeartAttackEntityTick(this);
            return;
        }
        if (this.master == null) {
            LivingEntity attacking;
            UUID ownerId;
            if (this.f_19797_ % 40 == 0 && (ownerId = this.getOwnerId()) != null) {
                ServerLevel serverWorld = (ServerLevel)this.m_9236_();
                for (ServerPlayer serverPlayerEntity : serverWorld.m_6907_()) {
                    if (!serverPlayerEntity.m_20148_().equals(ownerId)) continue;
                    this.master = serverPlayerEntity;
                }
            }
            if ((attacking = this.m_21214_()) != null && this.m_6779_(attacking)) {
                this.m_6710_(attacking);
            }
        } else {
            if (this.f_19797_ % 19 == 0 && this.m_20096_() && this.m_20184_().m_82556_() > 0.005) {
                this.m_5496_((SoundEvent)JSoundRegistry.SHA_TREAD.get(), 0.5f, 1.0f);
            }
            if (this.f_19797_ > 300 || !this.master.m_6084_()) {
                this.m_6074_();
            }
            Vec3 pos = this.m_20182_();
            LivingEntity target = this.m_5448_();
            if (target == null) {
                if (this.f_19797_ % 10 == 0) {
                    List toTrack = this.m_9236_().m_6443_(LivingEntity.class, new AABB(pos.m_82520_(16.0, 16.0, 16.0), pos.m_82520_(-16.0, -16.0, -16.0)), EntitySelector.f_20406_.and(e -> e != this && e != this.master));
                    LivingEntity coldTarget = null;
                    LivingEntity hotTarget = null;
                    for (LivingEntity living : toTrack) {
                        if (!this.m_6779_(living) || living.m_20159_() && living.m_20202_() == this.master) continue;
                        if (living.m_6060_()) {
                            this.m_6710_(living);
                            coldTarget = null;
                            hotTarget = null;
                            break;
                        }
                        if (coldTarget != null && hotTarget != null) continue;
                        if (living.m_21222_()) {
                            coldTarget = living;
                            continue;
                        }
                        hotTarget = living;
                    }
                    if (hotTarget != null) {
                        this.m_6710_(hotTarget);
                    } else if (coldTarget != null) {
                        this.m_6710_(coldTarget);
                    }
                }
            } else if (!this.m_6779_(target)) {
                this.m_6710_(null);
            }
        }
    }

    public void Explode() {
        JUtils.explode(this.m_9236_(), (Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.8f, JExplosionModifier.builder().particle((SimpleParticleType)JParticleTypeRegistry.BOOM_1.get()).blockInteraction(this.m_9236_().m_46469_().m_46207_(JCraft.STAND_GRIEFING) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).particleVelocity(Vec3.f_82478_).build());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<SheerHeartAttackEntity> state) {
        state.setAnimation(state.isMoving() ? SHA_WALK : SHA_IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

