/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity;

import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public final class StandMeteorEntity
extends Mob {
    private final Registry<Structure> structureRegistry;
    private static final ResourceLocation METEOR_LAND = JCraft.id("meteorite_land");
    private static final ResourceLocation METEOR_OCEAN = JCraft.id("meteorite_ocean");

    public StandMeteorEntity(Level level) {
        super((EntityType)JEntityTypeRegistry.STAND_METEOR.get(), level);
        if (level.m_5776_()) {
            this.structureRegistry = null;
            return;
        }
        this.structureRegistry = level.m_7654_().m_206579_().m_175515_(Registries.f_256944_);
        this.m_20334_(this.f_19796_.m_188500_() - 0.5, -this.f_19796_.m_188500_() * 10.0, this.f_19796_.m_188500_() - 0.5);
    }

    protected float m_6108_() {
        return 0.9f;
    }

    @NonNull
    public Vec3 m_20994_(double gravity, boolean isFalling, @NonNull Vec3 deltaMovement) {
        if (deltaMovement == null) {
            throw new NullPointerException("deltaMovement is marked non-null but is null");
        }
        if (!isFalling) {
            return deltaMovement;
        }
        return deltaMovement.m_82546_(RotationUtil.vecPlayerToWorld(0.0, gravity, 0.0, GravityChangerAPI.getGravityDirection((Entity)this)));
    }

    public void m_8119_() {
        super.m_8119_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_20096_()) {
                Structure meteorStructure;
                this.m_9236_().m_254849_((Entity)this, x, y, z, 3.0f, Level.ExplosionInteraction.TNT);
                Structure structure = meteorStructure = this.m_5842_() ? (Structure)this.structureRegistry.m_7745_(METEOR_OCEAN) : (Structure)this.structureRegistry.m_7745_(METEOR_LAND);
                if (meteorStructure == null) {
                    JCraft.LOGGER.error("Meteor structure was null!");
                } else {
                    StandMeteorEntity.placeStructure(meteorStructure, serverLevel, this.m_20183_());
                }
                this.m_146870_();
            }
        } else {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, false, x + this.f_19796_.m_188500_() * 4.0 - 2.0, y + this.f_19796_.m_188500_() * 4.0 - 2.0, z + this.f_19796_.m_188500_() * 4.0 - 2.0, this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
        }
    }

    public boolean m_6785_(double distanceToClosestPlayerSquared) {
        return distanceToClosestPlayerSquared > 262144.0;
    }

    public int m_20146_() {
        return this.m_6062_();
    }

    private static void placeStructure(Structure structure, ServerLevel serverLevel, BlockPos pos) {
        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
        StructureStart structureStart = structure.m_226596_(serverLevel.m_9598_(), chunkGenerator, chunkGenerator.m_62218_(), serverLevel.m_7726_().m_214994_(), serverLevel.m_215082_(), serverLevel.m_7328_(), new ChunkPos(pos), 0, (LevelHeightAccessor)serverLevel, holder -> true);
        if (!structureStart.m_73603_()) {
            JCraft.LOGGER.warn("Invalid StructureStart for meteor; " + String.valueOf(structureStart));
        } else {
            ChunkPos chunkPos2;
            BoundingBox boundingBox = structureStart.m_73601_();
            ChunkPos chunkPos1 = new ChunkPos(SectionPos.m_123171_((int)boundingBox.m_162395_()), SectionPos.m_123171_((int)boundingBox.m_162398_()));
            if (!StandMeteorEntity.checkLoaded(serverLevel, chunkPos1, chunkPos2 = new ChunkPos(SectionPos.m_123171_((int)boundingBox.m_162399_()), SectionPos.m_123171_((int)boundingBox.m_162401_())))) {
                return;
            }
            ChunkPos.m_45599_((ChunkPos)chunkPos1, (ChunkPos)chunkPos2).forEach(chunkPos -> structureStart.m_226850_((WorldGenLevel)serverLevel, serverLevel.m_215010_(), chunkGenerator, serverLevel.m_213780_(), new BoundingBox(chunkPos.m_45604_(), serverLevel.m_141937_(), chunkPos.m_45605_(), chunkPos.m_45608_(), serverLevel.m_151558_(), chunkPos.m_45609_()), chunkPos));
        }
    }

    private static boolean checkLoaded(ServerLevel level, ChunkPos start, ChunkPos end) {
        return ChunkPos.m_45599_((ChunkPos)start, (ChunkPos)end).allMatch(chunkPos -> level.m_46749_(chunkPos.m_45615_()));
    }
}

