/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.EnumSet;
import java.util.List;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.MoveUsage;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.common.network.s2c.DamageNumberPacket;
import net.arna.jcraft.common.util.ICustomDamageHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TrainingDummyEntity
extends Mob
implements GeoEntity,
ICustomDamageHandler {
    public static final int HIT_ANIMATION_LENGTH = 20;
    private static final EntityDataAccessor<Boolean> HAS_KNOCKDOWN = SynchedEntityData.m_135353_(TrainingDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> HIT_COUNTER = SynchedEntityData.m_135353_(TrainingDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Long> HIT_START_TIME = SynchedEntityData.m_135353_(TrainingDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private boolean invisible;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private int lastHitCounter = -1;
    public static final RawAnimation DUMMY_IDLE = RawAnimation.begin().thenLoop("animation.sandbag.idle");
    public static final RawAnimation DUMMY_HIT = RawAnimation.begin().thenPlayAndHold("animation.sandbag.hit");
    public static final RawAnimation DUMMY_KNOCKED_DOWN = RawAnimation.begin().thenPlay("animation.sandbag.knockdown").thenLoop("animation.sandbag.knockdownidle");
    public static final RawAnimation DUMMY_KNOCKDOWN_IDLE = RawAnimation.begin().thenPlay("animation.sandbag.knockdownidle");

    public TrainingDummyEntity(EntityType<? extends TrainingDummyEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(0.0f);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createLivingAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 2.0);
    }

    public TrainingDummyEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends TrainingDummyEntity>)((EntityType)JEntityTypeRegistry.TRAINING_DUMMY.get()), level);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_KNOCKDOWN, (Object)false);
        this.f_19804_.m_135372_(HIT_COUNTER, (Object)0);
        this.f_19804_.m_135372_(HIT_START_TIME, (Object)0L);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Invisible", this.m_20145_());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.m_6842_(compound.m_128471_("Invisible"));
    }

    private boolean isOnKnockbackBlockingBlock() {
        BlockPos center = this.m_20183_();
        for (int y = 0; y >= -1; --y) {
            BlockPos checkPos = center.m_7918_(0, y, 0);
            if (!this.m_9236_().m_8055_(checkPos).m_204336_(JTagRegistry.DUMMY_KNOCKBACK_BLOCKING)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6094_() {
        return !this.isOnKnockbackBlockingBlock();
    }

    protected void m_7324_(@NotNull Entity entity) {
        if (!this.isOnKnockbackBlockingBlock()) {
            super.m_7324_(entity);
        }
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        if (mainHand.m_41619_() && offHand.m_41619_()) {
            if (!player.m_9236_().m_5776_()) {
                ItemStack dummyItem = new ItemStack((ItemLike)JItemRegistry.TRAINING_DUMMY.get());
                player.m_150109_().m_36054_(dummyItem);
                this.m_146870_();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean reflectsDamage() {
        return false;
    }

    @Override
    public boolean handleDamage(Vec3 kbVec, int stunTicks, int stunLevel, boolean overrideStun, float damage, boolean lift, int blockstun, DamageSource source, Entity attacker, CommonHitPropertyComponent.HitAnimation hitAnimation, MoveUsage moveUsage, boolean canBackstab, boolean unblockable) {
        if (!this.m_9236_().m_5776_() && !this.m_213877_()) {
            if (damage > 0.0f) {
                TrainingDummyEntity.sendDamageNumberPacket(this, damage);
            }
            if (attacker != null) {
                double deltaX = attacker.m_20185_() - this.m_20185_();
                double deltaZ = attacker.m_20189_() - this.m_20189_();
                float yaw = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI) - 90.0f;
                this.m_146922_(yaw);
                this.m_5616_(yaw);
                this.m_5618_(yaw);
            }
            int currentCounter = (Integer)this.f_19804_.m_135370_(HIT_COUNTER);
            this.f_19804_.m_135381_(HIT_COUNTER, (Object)(currentCounter + 1));
            this.f_19804_.m_135381_(HIT_START_TIME, (Object)this.m_9236_().m_46467_());
            this.m_9236_().m_7605_((Entity)this, (byte)32);
            this.m_9236_().m_7605_((Entity)this, (byte)2);
            if (!(this.isOnKnockbackBlockingBlock() || kbVec == null || kbVec.f_82479_ == 0.0 && kbVec.f_82480_ == 0.0 && kbVec.f_82481_ == 0.0)) {
                this.m_5997_(kbVec.f_82479_, kbVec.f_82480_, kbVec.f_82481_);
                this.f_19812_ = true;
            }
            if (stunTicks > 0) {
                this.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.DAZED.get(), stunTicks, stunLevel, false, false));
            }
        }
        return false;
    }

    protected void m_6475_(@NotNull DamageSource damageSource, float damageAmount) {
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (!(this.m_9236_().m_5776_() || this.m_213877_() || this.m_6673_(source) || this.invisible)) {
            Entity directAttacker;
            if (amount > 0.0f) {
                TrainingDummyEntity.sendDamageNumberPacket(this, amount);
            }
            if ((directAttacker = source.m_7639_()) != null) {
                double deltaX = directAttacker.m_20185_() - this.m_20185_();
                double deltaZ = directAttacker.m_20189_() - this.m_20189_();
                float yaw = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI) - 90.0f;
                this.m_146922_(yaw);
                this.m_5616_(yaw);
                this.m_5618_(yaw);
            }
            int currentCounter = (Integer)this.f_19804_.m_135370_(HIT_COUNTER);
            this.f_19804_.m_135381_(HIT_COUNTER, (Object)(currentCounter + 1));
            this.f_19804_.m_135381_(HIT_START_TIME, (Object)this.m_9236_().m_46467_());
            this.m_9236_().m_7605_((Entity)this, (byte)32);
            this.m_9236_().m_7605_((Entity)this, (byte)2);
            return true;
        }
        return false;
    }

    private static void sendDamageNumberPacket(TrainingDummyEntity entity, float damage) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 pos = entity.m_20182_();
        List nearbyPlayers = serverLevel.m_45976_(ServerPlayer.class, new AABB(pos.m_82520_(64.0, 64.0, 64.0), pos.m_82492_(64.0, 64.0, 64.0)));
        if (!nearbyPlayers.isEmpty()) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            new DamageNumberPacket(entity.m_19879_(), damage).write(buf);
            NetworkManager.sendToPlayers((Iterable)nearbyPlayers, (ResourceLocation)JPacketRegistry.S2C_DAMAGE_NUMBER, (FriendlyByteBuf)buf);
        }
    }

    public void m_8119_() {
        Entity holder;
        super.m_8119_();
        if (this.m_21223_() < this.m_21233_()) {
            this.m_21153_(this.m_21233_());
        }
        if (!this.m_9236_().m_5776_()) {
            boolean hasKnockdown = this.m_21023_((MobEffect)JStatusRegistry.KNOCKDOWN.get());
            boolean currentSyncValue = (Boolean)this.f_19804_.m_135370_(HAS_KNOCKDOWN);
            if (currentSyncValue != hasKnockdown) {
                this.f_19804_.m_135381_(HAS_KNOCKDOWN, (Object)hasKnockdown);
            }
        }
        if (this.m_21523_() && (holder = this.m_21524_()) != null) {
            this.enforceLeashDistance(holder);
        }
    }

    private void enforceLeashDistance(Entity holder) {
        double targetDistance = 2.0;
        double currentDistance = this.m_20270_(holder);
        if (currentDistance > targetDistance) {
            Vec3 holderPos = holder.m_20182_();
            Vec3 myPos = this.m_20182_();
            Vec3 direction = holderPos.m_82546_(myPos).m_82541_();
            double excess = currentDistance - targetDistance;
            double springForce = excess * 0.2;
            Vec3 currentVel = this.m_20184_();
            Vec3 correction = direction.m_82490_(springForce);
            this.m_20256_(currentVel.m_82549_(correction));
            this.f_19812_ = true;
        }
    }

    public void m_7822_(byte id) {
        if (id == 32) {
            if (this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12591_, this.m_5720_(), 0.3f, 1.0f, false);
            }
        } else if (id == 2) {
            if (this.m_9236_().m_5776_()) {
                this.f_20917_ = 10;
                this.f_20916_ = 10;
            }
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                if (!TrainingDummyEntity.this.m_21523_()) {
                    return false;
                }
                Entity holder = TrainingDummyEntity.this.m_21524_();
                if (holder == null) {
                    return false;
                }
                if (holder instanceof LeashFenceKnotEntity) {
                    return TrainingDummyEntity.this.m_20280_(holder) > 0.25;
                }
                if (holder instanceof LivingEntity) {
                    return TrainingDummyEntity.this.m_20280_(holder) > 1.0;
                }
                return false;
            }

            public void m_8037_() {
                Entity holder = TrainingDummyEntity.this.m_21524_();
                if (holder != null) {
                    TrainingDummyEntity.this.m_21573_().m_5624_(holder, 0.5);
                }
            }
        });
    }

    protected void m_8024_() {
        Entity holder;
        if (this.m_21523_() && (holder = this.m_21524_()) != null) {
            double requiredDistance;
            if (holder instanceof LeashFenceKnotEntity) {
                requiredDistance = 0.25;
            } else if (holder instanceof LivingEntity) {
                requiredDistance = 1.0;
            } else {
                return;
            }
            if (this.m_20280_(holder) > requiredDistance) {
                this.m_21573_().m_5624_(holder, 0.5);
            }
        }
    }

    public boolean m_142066_() {
        return true;
    }

    public boolean m_142065_() {
        return true;
    }

    public boolean m_7301_(@NotNull MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance);
    }

    public boolean m_6673_(DamageSource damageSource) {
        return false;
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return List.of();
    }

    @NotNull
    public ItemStack m_6844_(@NotNull EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_6052_() {
        return false;
    }

    public boolean m_20151_() {
        return false;
    }

    public boolean m_8077_() {
        return false;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237119_();
    }

    @NotNull
    public Component m_7755_() {
        return Component.m_237119_();
    }

    public Component m_7770_() {
        return null;
    }

    public void m_20340_(boolean alwaysRenderNameTag) {
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_12591_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public boolean m_5801_() {
        return true;
    }

    @NotNull
    public Pose m_20089_() {
        if (this.m_21023_((MobEffect)JStatusRegistry.KNOCKDOWN.get())) {
            return Pose.STANDING;
        }
        return super.m_20089_();
    }

    public boolean m_5789_() {
        return true;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)JItemRegistry.TRAINING_DUMMY.get());
    }

    protected void m_8034_() {
        this.m_6842_(this.invisible);
    }

    public void m_6842_(boolean invisible) {
        this.invisible = invisible;
        super.m_6842_(invisible);
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<TrainingDummyEntity> state) {
        boolean stillInHitAnimation;
        boolean hasKnockdown = this.m_9236_().m_5776_() ? ((Boolean)this.f_19804_.m_135370_(HAS_KNOCKDOWN)).booleanValue() : this.m_21023_((MobEffect)JStatusRegistry.KNOCKDOWN.get());
        if (hasKnockdown) {
            state.setAnimation(DUMMY_KNOCKED_DOWN);
            return PlayState.CONTINUE;
        }
        int currentHitCounter = (Integer)this.f_19804_.m_135370_(HIT_COUNTER);
        long hitStartTime = (Long)this.f_19804_.m_135370_(HIT_START_TIME);
        long currentTime = this.m_9236_().m_46467_();
        if (currentHitCounter != this.lastHitCounter && currentHitCounter > 0) {
            this.lastHitCounter = currentHitCounter;
            state.getController().forceAnimationReset();
            state.setAnimation(DUMMY_HIT);
            return PlayState.CONTINUE;
        }
        boolean bl = stillInHitAnimation = currentTime - hitStartTime < 20L && hitStartTime > 0L;
        if (stillInHitAnimation) {
            state.setAnimation(DUMMY_HIT);
            return PlayState.CONTINUE;
        }
        state.setAnimation(DUMMY_IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

