/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.ai.goal;

import java.util.EnumSet;
import net.arna.jcraft.common.entity.PlayerCloneEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;

public class CloneAttackGoal
extends Goal {
    private final PlayerCloneEntity clone;
    private final LookControl cloneLookControl;
    private final PathNavigation cloneNavigation;
    private LivingEntity target;
    private final double speed;
    private long lastUpdateTime;

    public CloneAttackGoal(PlayerCloneEntity mob, double speed) {
        this.clone = mob;
        this.cloneLookControl = mob.m_21563_();
        this.cloneNavigation = mob.m_21573_();
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long l = this.clone.m_9236_().m_46467_();
        if (l - this.lastUpdateTime < 10L) {
            return false;
        }
        this.lastUpdateTime = l;
        this.target = this.clone.m_5448_();
        if (this.target == null) {
            return false;
        }
        if (!this.target.m_6084_()) {
            return false;
        }
        Path path = this.cloneNavigation.m_6570_((Entity)this.target, 0);
        if (path != null) {
            return true;
        }
        return this.getSquaredMaxAttackDistance(this.target) >= this.clone.m_20280_((Entity)this.target);
    }

    public boolean m_8045_() {
        if (this.target == null) {
            return false;
        }
        if (!this.target.m_6084_() || this.target.m_213877_()) {
            return false;
        }
        if (this.clone.m_20280_((Entity)this.target) > 1024.0) {
            return false;
        }
        if (this.target == this.clone.getMaster()) {
            return false;
        }
        return !this.cloneNavigation.m_26571_() || this.m_8036_();
    }

    public void m_8056_() {
        this.clone.m_21561_(true);
    }

    public void m_8041_() {
        this.target = null;
        this.clone.m_6710_(null);
        this.clone.m_21561_(false);
        this.cloneNavigation.m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        this.cloneNavigation.m_5624_((Entity)this.target, this.speed);
        this.cloneLookControl.m_24960_((Entity)this.target, 30.0f, 30.0f);
        double d = this.getSquaredMaxAttackDistance(this.target);
        if (this.target.m_20280_((Entity)this.clone) <= d && this.clone.getCooldown() <= 0) {
            this.clone.startCooldown();
            this.clone.m_6674_(InteractionHand.MAIN_HAND);
            this.clone.m_7327_((Entity)this.target);
        }
    }

    private double getSquaredMaxAttackDistance(LivingEntity entity) {
        return 1.44f + entity.m_20205_();
    }
}

