/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.ai.goal;

import java.util.EnumSet;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class StunningMeleeAttackGoal
extends Goal {
    protected final PathfinderMob mob;
    private final double speed;
    private final boolean pauseWhenMobIdle;
    private final int stunT;
    private Path path;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int updateCountdownTicks;
    private int cooldown;
    private long lastUpdateTime;

    public StunningMeleeAttackGoal(PathfinderMob mob, double speed, boolean pauseWhenMobIdle, int stunT) {
        this.mob = mob;
        this.speed = speed;
        this.pauseWhenMobIdle = pauseWhenMobIdle;
        this.stunT = stunT;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long l = this.mob.m_9236_().m_46467_();
        if (l - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = l;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getSquaredMaxAttackDistance(livingEntity) >= this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (!this.pauseWhenMobIdle) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingEntity.m_20183_())) {
            return false;
        }
        return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speed);
        this.mob.m_21561_(true);
        this.updateCountdownTicks = 0;
        this.cooldown = 0;
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        double d = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
        if ((this.pauseWhenMobIdle || this.mob.m_21574_().m_148306_((Entity)target)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || target.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
            this.targetX = target.m_20185_();
            this.targetY = target.m_20186_();
            this.targetZ = target.m_20189_();
            this.updateCountdownTicks = 4 + this.mob.m_217043_().m_188503_(7) + (d > 256.0 ? (d > 1024.0 ? 10 : 5) : 0);
            if (!this.mob.m_21573_().m_5624_((Entity)target, this.speed)) {
                this.updateCountdownTicks += 15;
            }
            this.updateCountdownTicks = this.m_183277_(this.updateCountdownTicks);
        }
        this.cooldown = Math.max(this.cooldown - 1, 0);
        this.attack(target, d);
    }

    protected void attack(LivingEntity target, double squaredDistance) {
        double d = this.getSquaredMaxAttackDistance(target);
        if (!(squaredDistance <= d) || this.cooldown > 0) {
            return;
        }
        this.resetCooldown();
        this.mob.m_6674_(InteractionHand.MAIN_HAND);
        if (this.mob.m_7327_((Entity)target)) {
            target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.DAZED.get(), this.stunT, 1, true, false));
        }
    }

    protected void resetCooldown() {
        this.cooldown = this.m_183277_(20);
    }

    protected boolean isCooledDown() {
        return this.cooldown <= 0;
    }

    protected int getCooldown() {
        return this.cooldown;
    }

    protected int getMaxCooldown() {
        return this.m_183277_(20);
    }

    protected double getSquaredMaxAttackDistance(LivingEntity entity) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + entity.m_20205_();
    }
}

