/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.damage;

import javax.annotation.Nullable;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.stand.StandEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;

public class JDamageSources {
    public static final ResourceKey<DamageType> STAND = JDamageSources.createDamageType("stand");
    public static final ResourceKey<DamageType> WHITE_SNAKE_POISON = JDamageSources.createDamageType("wspoison");
    public static final ResourceKey<DamageType> BLEEDING = JDamageSources.createDamageType("jbleeding");
    public static final ResourceKey<DamageType> PHPOISON = JDamageSources.createDamageType("phpoison");

    public static ResourceKey<DamageType> createDamageType(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)JCraft.id(name));
    }

    public static DamageSource create(Level world, ResourceKey<DamageType> key, @Nullable Entity source, @Nullable Entity attacker) {
        return new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(key), source, attacker);
    }

    public static DamageSource create(Level world, ResourceKey<DamageType> key, @Nullable Entity attacker) {
        return new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(key), attacker);
    }

    public static DamageSource create(Level world, ResourceKey<DamageType> key) {
        return new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(key));
    }

    @NonNull
    public static DamageSource stand(StandEntity<?, ?> stand) {
        return JDamageSources.create(stand.m_9236_(), STAND, (Entity)stand.getUser());
    }

    @Contract(value="_ -> new", pure=true)
    @NonNull
    public static DamageSource whitesnakePoison(Entity user) {
        return JDamageSources.create(user.m_9236_(), WHITE_SNAKE_POISON, user);
    }

    @NonNull
    public static DamageSource bleeding(Level world) {
        return JDamageSources.create(world, BLEEDING);
    }

    @NonNull
    public static DamageSource phpoison(Level world) {
        return JDamageSources.create(world, PHPOISON);
    }
}

