/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.npc;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.tickable.JEnemies;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AyaTsujiEntity
extends PathfinderMob
implements GeoEntity,
Merchant {
    private Player tradingPlayer;
    private final MerchantOffers merchantOffers = new MerchantOffers();
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.aya_tsuji.walk");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.aya_tsuji.idle");

    public AyaTsujiEntity(Level world) {
        super((EntityType)JEntityTypeRegistry.AYA_TSUJI.get(), world);
        CommonStandComponent standData = JComponentPlatformUtils.getStandComponent((LivingEntity)this);
        standData.setType((StandType)JStandTypeRegistry.CINDERELLA.get());
        standData.setSkin(0);
        if (world.m_5776_()) {
            return;
        }
        JEnemies.add((Mob)this);
        ItemStack[] masks = new ItemStack[4];
        for (int i = 0; i <= 3; ++i) {
            masks[i] = new ItemStack((ItemLike)JItemRegistry.CINDERELLA_MASK.get());
            if (i <= 0) continue;
            CompoundTag nbt = masks[i].m_41784_();
            ListTag enchantments = new ListTag();
            CompoundTag enchantment = new CompoundTag();
            enchantment.m_128359_("id", "jcraft:cinderellas_kiss");
            enchantment.m_128376_("lvl", (short)i);
            enchantments.add((Object)enchantment);
            nbt.m_128365_("Enchantments", (Tag)enchantments);
        }
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 15), masks[0], 4, 0, 1.0f));
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 25), masks[1], 3, 0, 1.0f));
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 35), masks[2], 2, 0, 1.0f));
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42584_, 16), masks[0], 4, 0, 1.0f));
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42545_, 8), masks[1], 3, 0, 1.0f));
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42545_, 10), masks[2], 2, 0, 1.0f));
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42545_, 12), masks[3], 1, 0, 1.0f));
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)JItemRegistry.STELLAR_IRON_INGOT.get()), masks[1], 3, 0, 1.0f));
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)JItemRegistry.STAND_ARROW.get(), 1), masks[2], 2, 0, 1.0f));
        this.merchantOffers.add((Object)new MerchantOffer(new ItemStack((ItemLike)JItemRegistry.STAND_ARROW.get(), 2), masks[3], 1, 0, 1.0f));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(10, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 32.0f));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 32.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{IronGolem.class}));
    }

    public static AttributeSupplier.Builder createAyaTsujiAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @NonNull
    protected InteractionResult m_6071_(@NonNull Player player, @NonNull InteractionHand hand) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        if (!this.m_6616_().isEmpty()) {
            if (this.m_5448_() == player) {
                return InteractionResult.FAIL;
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_183595_());
    }

    public void m_7189_(@Nullable Player tradingPlayer) {
        this.tradingPlayer = tradingPlayer;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    @NotNull
    public MerchantOffers m_6616_() {
        return this.merchantOffers;
    }

    public void m_6255_(@NonNull MerchantOffers offers) {
        if (offers == null) {
            throw new NullPointerException("offers is marked non-null but is null");
        }
    }

    public void m_6996_(@NonNull MerchantOffer offer) {
        if (offer == null) {
            throw new NullPointerException("offer is marked non-null but is null");
        }
    }

    public void m_7713_(@NonNull ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xp) {
    }

    public boolean m_7826_() {
        return false;
    }

    @Nullable
    public SoundEvent m_7596_() {
        return null;
    }

    public boolean m_183595_() {
        return this.m_9236_().m_5776_();
    }

    public void m_8119_() {
        if (this.tradingPlayer != null) {
            if (this.f_21344_.m_26572_()) {
                this.f_21344_.m_26573_();
            }
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.tradingPlayer.m_146892_());
        }
        super.m_8119_();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle_controller", 10, this::idlePredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walk_controller", 10, this::walkPredicate)});
    }

    private PlayState walkPredicate(AnimationState<AyaTsujiEntity> state) {
        float velocityLengthSqr = (float)this.m_20184_().m_82553_();
        if (velocityLengthSqr < 0.05f) {
            return state.setAndContinue(IDLE);
        }
        state.setControllerSpeed(1.0f + velocityLengthSqr / 2.5f);
        return state.setAndContinue(WALK);
    }

    private PlayState idlePredicate(AnimationState<AyaTsujiEntity> state) {
        if (this.m_20184_().m_82556_() > 0.01 && this.m_5448_() == null) {
            return state.setAndContinue(IDLE);
        }
        return PlayState.STOP;
    }
}

