/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.stand.MagiciansRedEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class AnkhProjectile
extends AbstractArrow
implements GeoEntity {
    private int ticksInAir;
    private boolean variation = false;
    private double orbitRange = 3.0;
    private double orbitOffset = 0.0;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnkhProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.ANKH.get(), world);
    }

    public AnkhProjectile(Level world, LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.ANKH.get(), owner, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public void setOrbitRange(double range) {
        this.orbitRange = range;
    }

    public void setOrbitOffset(double offset) {
        this.orbitOffset = offset;
    }

    public void setVariation(boolean variation) {
        this.variation = variation;
    }

    @NonNull
    public ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public boolean m_20068_() {
        return true;
    }

    protected boolean m_20073_() {
        return false;
    }

    public boolean m_36797_() {
        return this.variation;
    }

    @NonNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_11874_;
    }

    protected void m_5790_(@NonNull EntityHitResult entityHitResult) {
        if (entityHitResult == null) {
            throw new NullPointerException("entityHitResult is marked non-null but is null");
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (owner.m_20363_(entity) || entity == owner) {
            return;
        }
        entity.m_20254_(3);
        JUtils.projectileDamageLogic((Projectile)this, this.m_9236_(), entity, Vec3.f_82478_, 5, 1, false, 3.5f, 8, CommonHitPropertyComponent.HitAnimation.MID);
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        MagiciansRedEntity.ignite(this.m_9236_(), blockHitResult.m_82425_());
        super.m_8060_(blockHitResult);
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        tag.m_128379_("variation", this.variation);
        tag.m_128376_("life", (short)this.ticksInAir);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.ticksInAir = tag.m_128448_("life");
        this.variation = tag.m_128471_("variation");
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            Vec3 vel = this.m_20184_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * 0.5f) - 0.25, this.m_20186_() + (double)(this.f_19796_.m_188501_() * 0.5f) - 0.25, this.m_20189_() + (double)(this.f_19796_.m_188501_() * 0.5f) - 0.25, vel.f_82479_ / 2.0, vel.f_82480_ / 2.0, vel.f_82481_ / 2.0);
        } else {
            if (this.f_36703_) {
                this.m_146870_();
            } else {
                ++this.ticksInAir;
                if (this.ticksInAir >= 600) {
                    this.m_146870_();
                }
            }
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                if (owner.m_6084_()) {
                    if (this.variation) {
                        this.f_36703_ = false;
                        this.f_36704_ = 0;
                        double orbitProg = Math.toRadians((double)(this.f_19797_ * 3) + this.orbitOffset);
                        Vec3 orbitPos = owner.m_146892_().m_82520_(Math.sin(orbitProg) * this.orbitRange, 0.0, Math.cos(orbitProg) * this.orbitRange);
                        Vec3 pos = this.m_20182_();
                        Vec3 towardsVel = orbitPos.m_82546_(pos).m_82541_().m_82490_(0.2);
                        double stabilization = Math.min(pos.m_82554_(orbitPos), 0.8);
                        this.m_20256_(this.m_20184_().m_82490_(stabilization).m_82549_(towardsVel));
                        this.f_19864_ = true;
                        Vec3 nextPos = pos.m_82549_(this.m_20184_());
                        EntityHitResult entityHitResult = this.m_6351_(pos, nextPos);
                        if (entityHitResult != null) {
                            this.m_5790_(entityHitResult);
                        }
                    }
                } else {
                    this.variation = false;
                }
            } else {
                this.m_146870_();
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

