/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashSet;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BisectProjectile
extends AbstractArrow
implements GeoEntity {
    private final IntOpenHashSet hit = new IntOpenHashSet(8);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(BisectProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation FIRE = RawAnimation.begin().thenPlayAndHold("animation.bisect.spawn");

    public BisectProjectile(Level level) {
        super((EntityType)JEntityTypeRegistry.BISECT.get(), level);
        this.m_20242_(true);
    }

    public BisectProjectile(Level level, LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.BISECT.get(), owner, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
    }

    public float getScale() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    protected void m_6901_() {
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Vec3 curPos = this.m_20182_();
        Entity owner = this.m_19749_();
        float scale = this.getScale();
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            HashSet<Entity> filter = new HashSet<Entity>(2);
            filter.add(owner);
            filter.add((Entity)this);
            if (owner.m_20160_()) {
                filter.addAll(owner.m_20197_());
            }
            DamageSource damageSource = this.m_9236_().m_269111_().m_269333_(livingOwner);
            Vec3 towardsVec = curPos.m_82546_(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_));
            float yaw = (this.m_146908_() + 90.0f) * ((float)Math.PI / 180);
            Vec3 sideVec = new Vec3((double)Mth.m_14031_((float)yaw), 0.0, (double)Mth.m_14089_((float)yaw));
            HashSet<LivingEntity> hurtAll = new HashSet<LivingEntity>();
            for (double i = 0.0; i < 2.0; i += 1.0) {
                hurtAll.addAll(JUtils.generateHitbox(this.m_9236_(), curPos.m_82549_(towardsVec.m_82490_(i / 2.0)), 1.0 * (double)scale, filter));
                hurtAll.addAll(JUtils.generateHitbox(this.m_9236_(), curPos.m_82549_(towardsVec.m_82490_(i / 2.0)).m_82549_(sideVec.m_82490_((double)scale)), 1.0 * (double)scale, filter));
                hurtAll.addAll(JUtils.generateHitbox(this.m_9236_(), curPos.m_82549_(towardsVec.m_82490_(i / 2.0)).m_82546_(sideVec.m_82490_((double)scale)), 1.0 * (double)scale, filter));
            }
            hurtAll.removeIf(e -> !JUtils.canDamage(damageSource, (Entity)e));
            hurtAll.removeIf(e -> this.hit.contains(e.m_19879_()));
            if (!hurtAll.isEmpty()) {
                for (LivingEntity l : hurtAll) {
                    LivingEntity target = JUtils.getUserIfStand(l);
                    Attacks.damageLogic(this.m_9236_(), target, this.m_20184_(), (int)(10.0f * scale), 3, false, 5.0f * scale, true, 0, damageSource, owner, CommonHitPropertyComponent.HitAnimation.LAUNCH, false, true);
                    this.hit.add(target.m_19879_());
                }
                JCraft.createParticle((ServerLevel)this.m_9236_(), curPos.f_82479_ + this.f_19796_.m_188583_() * 0.25, curPos.f_82480_ + this.f_19796_.m_188583_() * 0.25, curPos.f_82481_ + this.f_19796_.m_188583_() * 0.25, JParticleType.HIT_SPARK_3);
                this.m_5496_(SoundEvents.f_12317_, 1.0f, 0.5f);
            }
            if (this.f_19797_ > 240) {
                this.m_146870_();
            }
        }
    }

    protected void m_6532_(@NonNull HitResult result) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
    }

    @NonNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<BisectProjectile> state) {
        return state.setAndContinue(FIRE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

