/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.projectile.JAttackEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlockProjectile
extends JAttackEntity
implements GeoEntity {
    private final int maxTimeToLaunch = 15;
    private int timeToLaunch = 15;
    private int timeLaunched = 0;
    private boolean toRefresh = false;
    private boolean launched = false;
    private boolean hit = false;
    private static final EntityDataAccessor<Byte> EFFECT = SynchedEntityData.m_135353_(BlockProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<ItemStack> BLOCKSTACK = SynchedEntityData.m_135353_(BlockProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @NonNull
    private ItemStack item = ItemStack.f_41583_;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.block.idle");

    public BlockProjectile(Level world) {
        super((EntityType<? extends LivingEntity>)((EntityType)JEntityTypeRegistry.BLOCK_PROJECTILE.get()), world);
        this.m_20242_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EFFECT, (Object)0);
        this.f_19804_.m_135372_(BLOCKSTACK, (Object)Items.f_41905_.m_7968_());
    }

    public void setBlockStack(ItemStack stack) {
        this.f_19804_.m_135381_(BLOCKSTACK, (Object)stack);
        this.item = stack;
    }

    public void setEffect(byte effect) {
        this.f_19804_.m_135381_(EFFECT, (Object)effect);
    }

    public void markRefresh() {
        this.toRefresh = true;
    }

    private void breakBlock() {
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        this.m_20334_(0.0, 0.0, 0.0);
        this.setEffect((byte)1);
        this.m_147244_(false);
        this.m_6074_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            Vec3 vel = this.m_20184_();
            byte effect = (Byte)this.f_19804_.m_135370_(EFFECT);
            if (effect != 0) {
                for (int i = 0; i < 32; ++i) {
                    SimpleParticleType particle = effect == 1 ? new BlockParticleOption(ParticleTypes.f_123794_, Block.m_49814_((Item)((ItemStack)this.f_19804_.m_135370_(BLOCKSTACK)).m_41720_()).m_49966_()) : ParticleTypes.f_123789_;
                    this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_() + vel.f_82479_ + this.f_19796_.m_188500_() - 0.5, this.m_20186_() + vel.f_82480_ + this.f_19796_.m_188500_() - 0.5, this.m_20189_() + vel.f_82481_ + this.f_19796_.m_188500_() - 0.5, vel.f_82479_ + this.f_19796_.m_188500_() * 2.0 - 1.0, vel.f_82480_ + this.f_19796_.m_188500_() * 2.0 - 1.0, vel.f_82481_ + this.f_19796_.m_188500_() * 2.0 - 1.0);
                }
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, this.m_20185_() + this.f_19796_.m_188500_() - 0.5, this.m_20186_() + this.f_19796_.m_188500_() - 0.5, this.m_20189_() + this.f_19796_.m_188500_() - 0.5, vel.f_82479_ / 2.0, vel.f_82480_ / 2.0, vel.f_82481_ / 2.0);
        } else {
            if (this.master == null || this.f_20919_ > 1) {
                this.m_146870_();
                return;
            }
            if ((Byte)this.f_19804_.m_135370_(EFFECT) != 0) {
                this.setEffect((byte)0);
            }
            if (this.hit || this.m_20096_() || this.f_19797_ > 200) {
                this.breakBlock();
            }
            --this.timeToLaunch;
            if (this.timeToLaunch == 0) {
                if (this.toRefresh) {
                    this.timeToLaunch = 15;
                    this.toRefresh = false;
                    this.m_20334_(0.0, 0.0, 0.0);
                    this.setEffect((byte)2);
                    this.m_5496_((SoundEvent)JSoundRegistry.CMOON_BLOCKHALT.get(), 1.0f, 1.0f);
                } else if (!this.launched) {
                    Vec3 eP = this.master.m_146892_();
                    Vec3 rangeMod = this.master.m_20154_().m_82490_(32.0);
                    EntityHitResult eHit = ProjectileUtil.m_37287_((Entity)this.master, (Vec3)eP, (Vec3)eP.m_82549_(rangeMod), (AABB)this.master.m_20191_().m_82400_(32.0), EntitySelector.f_20406_.and(entity -> entity != this), (double)1024.0);
                    Vec3 targetPos = Objects.requireNonNullElseGet(eHit, () -> this.m_9236_().m_45547_(new ClipContext(eP, eP.m_82549_(rangeMod), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.master))).m_82450_();
                    this.m_20256_(targetPos.m_82546_(this.m_20182_()).m_82541_());
                    this.m_5496_((SoundEvent)JSoundRegistry.CMOON_BLOCKLAUNCH.get(), 1.0f, 1.0f);
                    this.launched = true;
                    this.m_147244_(true);
                }
            }
            if (this.launched && this.timeLaunched < 20 && !this.hit) {
                ++this.timeLaunched;
                Set<LivingEntity> toHurt = JUtils.generateHitbox(this.m_9236_(), this.m_20182_(), 1.0, Set.of(this.master));
                DamageSource damageSource = this.m_9236_().m_269111_().m_269333_(this.master);
                for (LivingEntity living : toHurt) {
                    LivingEntity target = JUtils.getUserIfStand(living);
                    if (target == this.master || target == this || !JUtils.canDamage(damageSource, (Entity)target)) continue;
                    this.hit = true;
                    Attacks.damageLogic(this.m_9236_(), target, this.m_20184_(), 15, 1, true, 6.0f, false, 11, damageSource, (Entity)this.master, CommonHitPropertyComponent.HitAnimation.MID, false);
                }
            }
            if (this.timeLaunched == 20) {
                this.m_20242_(false);
            }
        }
    }

    public static AttributeSupplier.Builder createBlockAttributes() {
        return BlockProjectile.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22266_(Attributes.f_22279_).m_22268_(Attributes.f_22284_, 10.0).m_22266_(Attributes.f_22285_);
    }

    public void m_7334_(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() != null) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    protected SoundEvent m_7975_(@NonNull DamageSource source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return SoundEvents.f_12450_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12442_;
    }

    @NonNull
    protected AABB m_142242_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        double s = 0.5;
        return new AABB(x + s, y + s, z + s, x - s, y - s, z - s);
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        this.writeMasterNbt(tag);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.readMasterNbt(tag);
    }

    @Override
    public void m_8061_(@NonNull EquipmentSlot slot, @NonNull ItemStack stack) {
        if (slot == null) {
            throw new NullPointerException("slot is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        this.item = stack;
    }

    @Override
    @NonNull
    public ItemStack m_6844_(@NonNull EquipmentSlot slot) {
        if (slot == null) {
            throw new NullPointerException("slot is marked non-null but is null");
        }
        return this.item;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        return state.setAndContinue(IDLE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

