/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class BloodProjectile
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public BloodProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.BLOOD_PROJECTILE.get(), world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public BloodProjectile(Level world, LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.BLOOD_PROJECTILE.get(), owner, world);
        this.m_36740_(SoundEvents.f_12390_);
    }

    protected void m_6901_() {
        this.m_146870_();
    }

    protected void m_5790_(@NonNull EntityHitResult entityHitResult) {
        if (entityHitResult == null) {
            throw new NullPointerException("entityHitResult is marked non-null but is null");
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (owner.m_20363_(entity) || entity == owner) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            LivingEntity target = JUtils.getUserIfStand(living);
            Attacks.damageLogic(this.m_9236_(), target, Vec3.f_82478_, 10, 1, false, 2.0f, false, 6, this.m_9236_().m_269111_().m_269390_((Entity)this, owner), owner, CommonHitPropertyComponent.HitAnimation.MID);
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, true));
            this.m_146870_();
        }
        if (entity instanceof EndCrystal) {
            EndCrystal endCrystal = (EndCrystal)entity;
            endCrystal.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, owner), 2.0f);
        }
        this.m_5496_(SoundEvents.f_12390_, 1.0f, 0.5f);
    }

    @NonNull
    public ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public boolean m_20068_() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

