/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BubbleProjectile
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.bubble.idle");

    public BubbleProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.BUBBLE.get(), world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public BubbleProjectile(Level world, LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.BUBBLE.get(), owner, world);
        this.m_5602_((Entity)owner);
    }

    @NonNull
    public ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    protected void m_6532_(HitResult hitResult) {
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)hitResult);
            this.m_146852_(GameEvent.f_157777_, this.m_19749_());
            this.m_146870_();
        }
    }

    public boolean isInGround() {
        return this.f_36703_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_9236_().m_5776_() || this.m_19749_() != null && this.f_19797_ <= 1600)) {
            this.m_146870_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    @NonNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_11773_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<BubbleProjectile> state) {
        return state.setAndContinue(IDLE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

