/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.AttackData;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.events.JServerEvents;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BulletProjectile
extends AbstractArrow
implements GeoEntity {
    private int stunTicks;
    private float damage;
    private float mass;
    private boolean cancelMoves = false;
    private static final EntityDataAccessor<Float> CALIBER = SynchedEntityData.m_135353_(BulletProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public void setCaliber(float cal) {
        this.f_19804_.m_135381_(CALIBER, (Object)Float.valueOf(cal));
    }

    public float getCaliber() {
        return ((Float)this.f_19804_.m_135370_(CALIBER)).floatValue();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CALIBER, (Object)Float.valueOf(9.0f));
        super.m_8097_();
    }

    public BulletProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.BULLET.get(), world);
    }

    public BulletProjectile(Level world, LivingEntity owner, float caliber, float length, int stunTicks, float damage) {
        super((EntityType)JEntityTypeRegistry.BULLET.get(), owner, world);
        this.setCaliber(caliber);
        this.stunTicks = stunTicks;
        this.damage = damage;
        this.mass = length * caliber * caliber * (float)Math.PI * 1.3E-8f;
        this.m_36740_((SoundEvent)JSoundRegistry.BULLET_RICOCHET.get());
    }

    protected void m_6532_(HitResult hitResult) {
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        } else if (type == HitResult.Type.BLOCK) {
            boolean lowEnergy;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_();
            BlockState blockState = this.m_9236_().m_8055_(blockPos);
            if (blockState.m_60795_()) {
                return;
            }
            Vec3i intNormal = blockHitResult.m_82434_().m_122436_();
            Vec3 normal = new Vec3((double)intNormal.m_123341_(), (double)intNormal.m_123342_(), (double)intNormal.m_123343_());
            Vec3 impactVec = this.m_20184_();
            double impactAngleRad = Math.acos(normal.m_82526_(impactVec.m_82541_())) - 1.5707963267948966;
            double impactAngleDeg = Math.toDegrees(impactAngleRad);
            double kineticEnergy = (double)this.mass * impactVec.m_82556_() / 2.0;
            double hardness = blockState.m_60734_().m_155943_();
            if (hardness < 0.0) {
                hardness = Double.MAX_VALUE;
            }
            double penAngle = 45.0 + hardness * 5.0;
            boolean bl = lowEnergy = kineticEnergy < 0.001;
            if (impactAngleDeg > penAngle || lowEnergy) {
                boolean through;
                boolean bl2 = through = hardness <= 1.0;
                if (lowEnergy || !through) {
                    Level level;
                    this.m_8060_(blockHitResult);
                    this.m_9236_().m_220407_(GameEvent.f_157777_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)blockState));
                    if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JParticleTypeRegistry.HITSPARK_1.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    this.m_146870_();
                } else if (!this.m_9236_().m_5776_()) {
                    JUtils.serverPlaySound((SoundEvent)JSoundRegistry.BULLET_PENETRATE.get(), (ServerLevel)this.m_9236_(), this.m_20182_(), 32.0);
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JParticleTypeRegistry.STUN_PIERCE.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            } else {
                this.m_20256_(impactVec.m_82549_(normal).m_82490_(0.5 / hardness));
                if (!this.m_9236_().m_5776_()) {
                    JUtils.serverPlaySound((SoundEvent)JSoundRegistry.BULLET_RICOCHET.get(), (ServerLevel)this.m_9236_(), this.m_20182_(), 32.0);
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JParticleTypeRegistry.BLOCKSPARK.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public void m_20256_(@NonNull Vec3 velocity) {
        if (velocity == null) {
            throw new NullPointerException("velocity is marked non-null but is null");
        }
        super.m_20256_(velocity);
        this.f_19864_ = true;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!this.m_9236_().m_5776_()) {
                Entity owner = this.m_19749_();
                LivingEntity target = JUtils.getUserIfStand(living);
                DamageSource thrown = this.m_9236_().m_269111_().m_269390_((Entity)this, owner);
                AttackData attackData = new AttackData(this.m_20184_().m_82541_(), this.stunTicks, 1, false, this.damage, true, (int)(4.0f + this.damage), thrown, owner, CommonHitPropertyComponent.HitAnimation.MID, null, false, false, this.cancelMoves);
                Attacks.damageLogic(this.m_9236_(), target, attackData);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    JServerEvents.maybeLaunch(livingEntity, thrown, (ServerLevel)this.m_9236_(), livingEntity.m_21124_((MobEffect)JStatusRegistry.DAZED.get()), owner);
                }
                JUtils.serverPlaySound((SoundEvent)JSoundRegistry.BULLET_PENETRATE.get(), (ServerLevel)this.m_9236_(), this.m_20182_(), 32.0);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JParticleTypeRegistry.HITSPARK_2.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.m_146870_();
            }
        } else {
            super.m_5790_(entityHitResult);
        }
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            Vec3 velocity;
            double speed;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.f_36703_ && (speed = (velocity = this.m_20184_()).m_82553_()) > 0.1) {
                double currentX = this.m_20185_();
                double currentY = this.m_20186_();
                double currentZ = this.m_20189_();
                double prevX = currentX - velocity.f_82479_;
                double prevY = currentY - velocity.f_82480_;
                double prevZ = currentZ - velocity.f_82481_;
                double distance = Math.sqrt(Math.pow(currentX - prevX, 2.0) + Math.pow(currentY - prevY, 2.0) + Math.pow(currentZ - prevZ, 2.0));
                int particleCount = Math.max(1, (int)(distance * 4.0));
                for (int i = 0; i < particleCount; ++i) {
                    double t = (double)i / (double)particleCount;
                    double x = prevX + (currentX - prevX) * t;
                    double y = prevY + (currentY - prevY) * t;
                    double z = prevZ + (currentZ - prevZ) * t;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 1, 0.02, 0.02, 0.02, 0.0);
                }
            }
        }
    }

    public void m_7380_(@NonNull CompoundTag nbt) {
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        super.m_7380_(nbt);
        nbt.m_128405_("StunTicks", this.stunTicks);
        nbt.m_128350_("Mass", this.mass);
        nbt.m_128350_("Damage", this.damage);
    }

    public void m_7378_(@NonNull CompoundTag nbt) {
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        super.m_7378_(nbt);
        this.stunTicks = nbt.m_128451_("StunTicks");
        this.mass = nbt.m_128457_("Mass");
        this.damage = nbt.m_128457_("Damage");
    }

    @NonNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

