/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.Set;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GETreeEntity
extends AbstractArrow
implements GeoEntity {
    private final Vec3 launchVec;
    private final LivingEntity livingOwner;
    private boolean lockRotation = false;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation ANIMATION = RawAnimation.begin().thenPlay("animation.getree.spawn").thenPlay("animation.getree.idle").thenPlay("animation.getree.return");

    public GETreeEntity(Level world) {
        this(world, null, Vec3.f_82478_);
    }

    public GETreeEntity(Level world, LivingEntity owner, Vec3 launchVec) {
        super((EntityType)JEntityTypeRegistry.GE_TREE.get(), world);
        this.m_5602_((Entity)owner);
        this.m_20331_(true);
        this.m_20225_(true);
        this.livingOwner = owner;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.launchVec = launchVec;
    }

    public void m_146926_(float xRot) {
        if (this.lockRotation) {
            return;
        }
        super.m_146926_(xRot);
    }

    public void m_146922_(float yRot) {
        if (this.lockRotation) {
            return;
        }
        super.m_146922_(yRot);
    }

    public void m_8119_() {
        this.lockRotation = true;
        super.m_8119_();
        this.lockRotation = false;
        if (this.f_19797_ > 120) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_ || this.livingOwner == null) {
            return;
        }
        if (this.f_19797_ == 4) {
            DamageSource ds = this.m_9236_().m_269111_().m_269333_(this.livingOwner);
            Set<LivingEntity> hurt = JUtils.generateHitbox(this.m_9236_(), this.m_20182_().m_82549_(this.launchVec.m_82541_()), 2.5, Set.of(this, this.livingOwner));
            for (LivingEntity living : hurt) {
                if (!JUtils.canDamage(ds, (Entity)living)) continue;
                LivingEntity target = JUtils.getUserIfStand(living);
                if (this.livingOwner != target) {
                    Attacks.damageLogic(this.m_9236_(), target, Vec3.f_82478_, 25, 3, false, 7.0f, false, 11, ds, (Entity)this.livingOwner, CommonHitPropertyComponent.HitAnimation.MID, false);
                }
                JUtils.addVelocity((Entity)target, this.launchVec.f_82479_, this.launchVec.f_82480_, this.launchVec.f_82481_);
            }
        }
    }

    @NonNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public boolean m_7998_(@NonNull Entity entity, boolean force) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        return state.setAndContinue(ANIMATION);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

